/* ReSizeable RAMDisk - environment utilities
 * Copyright (c) 1992-1996, 2005 Marko Kohtala
 * Released under GNU GPL, read the file 'COPYING' for more information
 */

#include "srdisk.h"
#include <stdio.h>
#include <dos.h>
#include <string.h>

/*
   envptr - returns pointer to parent's copy of the environment
   Provided by Doug Dougherty, original source by S. Palmer.
   Heavily modified for srdisk use.
*/

extern int _fstrncmp( const char far * s1, const char far * s2, size_t n );

static char far *envptr(word *size)
{
    char far * env;

    #pragma pack(1)
    struct __attribute__((__packed__)) PSP {    /* Program Segment Prefix */
        word int20;
        word nextParagraph;
        byte r1;
        byte dispatcher[5];
        dword terminateVector;
        dword breakVector;
        dword critErrVector;
        word parent;        /* Undocumented in DOS 5 */
        word r2[10];
        word environment;
    } far * parent_p;

    struct __attribute__((__packed__)) MCB {    /* Memory Control Block */
        byte id;
        word owner;
        word size;
    } far * mcb = NULL;
    #pragma pack()

    #define getMCB(s) ((struct MCB far *)(MK_FP((word)(s) - 1, 0)))

    parent_p = MK_FP(((struct PSP far *)MK_FP(_psp, 0))->parent, 0);

    if (!parent_p || parent_p->int20 != 0x20CD)
        return NULL;
    mcb = getMCB(FP_SEG(parent_p));

    if (mcb->owner != FP_SEG(parent_p))
        return NULL;

    /* MS-DOS 3.2 first COMMAND.COM does not have environment pointer! */
    if (parent_p->environment)
    {
        env = MK_FP(parent_p->environment, 0);
        mcb = getMCB(FP_SEG(env));
    }
    else
    {
        mcb = (struct MCB far *)MK_FP(((word)FP_SEG(parent_p) + (word)getMCB(FP_SEG(parent_p))->size), 0);
        env = (char far *)MK_FP(((word)FP_SEG(mcb) + 1), 0);
    }

    *size = (mcb->size * 16);
    return env;
}

/*
   msetenv - place an environment variable in parent's copy of
             the environment.
   Provided by Doug Dougherty, original source by S. Palmer.
   Heavily modified for SRDISK use.
*/
static int msetenv(char *var, char *value)
{
    char far *env;
    word end, envp;
    word cp;
    int l;

    env = envptr(&end);
    if (!env) return -2;    /* Return error if no environment found */

    envp = 0;

    l = strlen(var);
    /* strupr(var); */

    #define ENVPPLUS(plus) ((unsigned char far *)MK_FP(FP_SEG(env), plus))
    /*
       Delete any existing variable with the name (var).
    */
    while (*ENVPPLUS(envp)) {
        if ((_fstrncmp(var,ENVPPLUS(envp),l) == 0) && (ENVPPLUS(envp)[l] == '=')) {
            cp = envp + _fstrlen(ENVPPLUS(envp)) + 1;
            /* bug in SRDISK v2.09: used to use _fmemcpy */
            _fmemmove(ENVPPLUS(envp),ENVPPLUS(cp),end-cp);
        }
        else {
            envp += _fstrlen(ENVPPLUS(envp)) + 1;
        }
    }

    /*
       If the variable fits, shovel it in at the end of the environment.
    */
    if (_fstrlen(value) && (end-envp) >= (l + _fstrlen(value) + 4)) {
        _fstrcpy(ENVPPLUS(envp),var);
        _fstrcat(ENVPPLUS(envp),"=");
        _fstrcat(ENVPPLUS(envp),value);
        l = _fstrlen(ENVPPLUS(envp));
        ENVPPLUS(envp)[l+1] = 0;
        *(word far *)ENVPPLUS(envp+l+2) = 0; /* Zero strings after environment */
        return 0;
    }

    /*
       Return error indication if variable did not fit.
    */
    return -1;
}

/*
**  Set environment variables to show SRDISK RAMDisks
**
**  Allowed not to return if error found, but if not serious error,
**  may return.
*/

void set_env()
{
    struct config_s far *conf = mainconf;
    char var[] = "SRDISK1";
    char drive[] = "A";
    int err;

    do {
      drive[0] = conf->drive;

      err = msetenv(var, drive);
      if (err == -1)
        fatal("Not enough environment space");
      if (err == -2)
        fatal("No environment found to modify");

      if (verbose > 1)
        printf("Set %s=%s\n", var, drive);

      var[6]++;
      conf = conf_ptr(conf->next_drive);
    } while ( conf );
}

