
/* Public Domain */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

int main(int argc, char **argv) {
  FILE* ff;
  const unsigned int buffersize = 8192;
  const char* names[] = {
  	"Ext5 setting", NULL,
  	"Ext15 setting", NULL,
  	"Ext85h setting", NULL,
  	"Ignore subsequent nested",
  	"Ignore subsequent logical",
  	"Ignore subsequent primary",
  	"Traditional order logical",
  	"Active priority",
  	"Subsequent primary after",
  	"",
  	"Ignore FAT32",
  	"Ignore LBA",
  	"DLA sort disable",
	};
  const char* extnames[] = {
        "0 = follow all",
        "1 = ignore all",
        "2 = follow first of any ext",
        "3 = follow first of this type",
        };
/*
mode_ignore_subsequent_nested	equ            1_00_00_00b
mode_ignore_subsequent_logical	equ           10_00_00_00b
mode_ignore_subsequent_primary	equ          100_00_00_00b
mode_traditional_order_logical	equ         1000_00_00_00b
mode_active_priority		equ       1_0000_00_00_00b
mode_subsequent_primary_after	equ      10_0000_00_00_00b
mode_disable_fat32		equ 00_1000_0000_00_00_00b
mode_disable_lba		equ 01_0000_0000_00_00_00b
mode_dlasort_zero		equ 10_0000_0000_00_00_00b
*/

  unsigned int ii, offset = 0, size,
	choices, query = 1, found = 0, at, current, flagsamount;
  unsigned long int want = 0, wantreplace = 0, wantminus = 0, wantplus = 0;
  uint8_t buffer[buffersize];
  flagsamount = (sizeof(names) / sizeof(names[0]));
  if (argc < 2) {
    printf("Usage: patchsca ldos.com [number]\n\n");
    printf("Supported flags:\n");
    for (ii = 0; ii < flagsamount; ++ ii) {
      if (ii + 1 < flagsamount && !names[ii + 1]) {
        printf(" %5u|%u: %s\n", 1 << ii, 1 << (ii + 1), names[ii]);
      } else if (!names[ii]) {
      } else if (!*names[ii]) {
      } else if ((1 << ii) > 8) {
        printf(" %4Xh=%5u: %s\n", 1 << ii, 1 << ii, names[ii]);
      } else {
        printf(" %5u: %s\n", 1 << ii, names[ii]);
      }
    }
    printf("Supported ext settings:\n");
    for (ii = 0; ii < 4; ++ ii) {
      printf(" %s\n", extnames[ii]);
    }
    return 0;
  }
  ff = fopen(argv[1], "r+b");
  if (! ff) {
    fprintf(stderr,"Error: Failed to open file: %s\n", argv[1]);
    return 2;
  }
  offset = 22;
  for (current = 2; current < argc; ++ current) {
    char *pp = argv[current];
    char *expectedend;
    char *parsedend;
    char replace_plus_minus = 0;
    unsigned int base = 10;
    unsigned long int vv = 0;
    if (pp[0] == '+') {
      ++ pp;
      replace_plus_minus = 1;
    } else if (pp[0] == '-') {
      ++ pp;
      replace_plus_minus = 2;
    } else {
      wantreplace = 1;
    }
    ii = strlen(pp);
    expectedend = &pp[ii];
    if (ii && (pp[ii - 1] == 'H' || pp[ii - 1] == 'h') ) {
      base = 16;
      -- expectedend;
    } else if (ii >= 2 && pp[0] == '0' && (pp[1] == 'B' || pp[1] == 'b') ) {
      pp += 2;
      base = 2;
    } else if (ii >= 2 && pp[0] == '0' && (pp[1] == 'X' || pp[1] == 'x') ) {
      pp += 2;
      base = 16;
    } else if (ii && (pp[ii - 1] == 'B' || pp[ii - 1] == 'b') ) {
      base = 2;
      -- expectedend;
    }
    vv = strtoul(pp, &parsedend, base);
    query = 0;
    if ((0 == vv && pp[0] != '0')
      || vv < 0 || vv > 0xFFFF
      || expectedend != parsedend) {
      fprintf(stderr,"Error: Invalid choice: %s\n", argv[current]);
      return 4;
    }
    switch (replace_plus_minus) {
    case 0:
      if (current != 2) {
        fprintf(stderr,"Error: Invalid choice: %s\n", argv[current]);
        return 4;
      }
      want = vv;
      wantplus = 0;
      wantminus = 0;
      break;
    case 1:
      wantplus |= vv;
      wantminus &= ~vv;
      break;
    case 2:
      wantminus |= vv;
      wantplus &= ~vv;
      break;
    }
  }
  size = fread(buffer, 1, buffersize, ff);
  if (size < 32) {
    fprintf(stderr,"Error: lCFG block not found\n");
    return 5;
  }
  choices = (size / 4) - 3;
  for (ii = 0; ii <= choices; ++ ii) {
    at = ii * 4;
    if (buffer[at] == 0xEB && ! memcmp(&buffer[at + 2], "lCFG", 4)) {
      found = 1;
      break;
    }
  }
  if (! found) {
    fprintf(stderr,"Error: lCFG block not found\n");
    return 6;
  }
  if (buffer[at + 6] != '0' || buffer[at + 7] != '0') {
    fprintf(stderr,"Error: Unknown version lCFG block found\n");
    return 7;
  }
  if ((3 << (offset - 16)) != (buffer[at + 8 + 2] &  (3 << (offset - 16)) )) {
    fprintf(stderr,"Error: lCFG block found doesn't contain this configuration\n");
    return 8;
  }
  if (! query) {
    if (wantreplace) {
      buffer[at + offset] = want & 255;
      buffer[at + offset + 1] = want >> 8;
    }
    buffer[at + offset] |= wantplus & 255;
    buffer[at + offset + 1] |= wantplus >> 8;
    buffer[at + offset] &= (~wantminus) & 255;
    buffer[at + offset + 1] &= (~wantminus) >> 8;
    fseek(ff, 0, SEEK_SET);
    if (size != fwrite(buffer, 1, size, ff)) {
      fprintf(stderr,"Error: Failed to write file\n");
      return 9;
    }
    printf("Configuration updated\n");
  }
  {
    int value;
    value = buffer[at + offset] + buffer[at + offset + 1] * 256;
    printf("Current mode = %u = %04Xh\n", value, value);
    for (ii = 0; ii < flagsamount; ++ ii) {
      if (ii + 1 < flagsamount && !names[ii + 1]) {
        printf("%s is %s\n", names[ii], extnames[(value >> ii) & 3]);
      } else if (!names[ii]) {
      } else if (!*names[ii]) {
        if (value & (1 << ii)) {
          printf("Unknown flag %u is ON\n", 1 << ii);
        }
      } else {
        printf("%s is %s\n", names[ii], value & (1 << ii) ? "ON" : "OFF");
      }
    }
    for (; ii < 16; ++ ii) {
      if (value & (1 << ii)) {
        printf("Unknown flag %u is ON\n", 1 << ii);
      }
    }
  }
  return 0;
}
