
/* Public Domain */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

int main(int argc, char **argv) {
  FILE* ff;
  const unsigned int buffersize = 8192;
  const char* names[] = { "Check", "Assume",
	"Check only valid", "Check only IISP" };
  unsigned int ii, offset = 0, size,
	choices, query = 1, found = 0, at, current;
  unsigned long int want = 0, wantreplace = 0, wantminus = 0, wantplus = 0;
  uint8_t buffer[buffersize];
  if (argc < 2) {
    printf("Usage: patchdeb edrdos.com [number]\n\n");
    printf("Supported flags:\n");
    for (ii = 0; ii < (sizeof(names) / sizeof(names[0])); ++ ii) {
      printf(" %2u: %s\n", 1 << ii, names[ii]);
    }
    return 0;
  }
  ff = fopen(argv[1], "r+b");
  if (! ff) {
    fprintf(stderr,"Error: Failed to open file: %s\n", argv[1]);
    return 2;
  }
  offset = 20;
  for (current = 2; current < argc; ++ current) {
    char *pp = argv[current];
    char *expectedend;
    char *parsedend;
    char replace_plus_minus = 0;
    unsigned int base = 10;
    unsigned long int vv = 0;
    if (pp[0] == '+') {
      ++ pp;
      replace_plus_minus = 1;
    } else if (pp[0] == '-') {
      ++ pp;
      replace_plus_minus = 2;
    } else {
      wantreplace = 1;
    }
    ii = strlen(pp);
    expectedend = &pp[ii];
    if (ii && (pp[ii - 1] == 'H' || pp[ii - 1] == 'h') ) {
      base = 16;
      -- expectedend;
    } else if (ii >= 2 && pp[0] == '0' && (pp[1] == 'B' || pp[1] == 'b') ) {
      pp += 2;
      base = 2;
    } else if (ii >= 2 && pp[0] == '0' && (pp[1] == 'X' || pp[1] == 'x') ) {
      pp += 2;
      base = 16;
    } else if (ii && (pp[ii - 1] == 'B' || pp[ii - 1] == 'b') ) {
      base = 2;
      -- expectedend;
    }
    vv = strtoul(pp, &parsedend, base);
    query = 0;
    if ((0 == vv && pp[0] != '0')
      || vv < 0 || vv > 255
      || expectedend != parsedend) {
      fprintf(stderr,"Error: Invalid choice: %s\n", argv[current]);
      return 4;
    }
    switch (replace_plus_minus) {
    case 0:
      if (current != 2) {
        fprintf(stderr,"Error: Invalid choice: %s\n", argv[current]);
        return 4;
      }
      want = vv;
      wantplus = 0;
      wantminus = 0;
      break;
    case 1:
      wantplus |= vv;
      wantminus &= ~vv;
      break;
    case 2:
      wantminus |= vv;
      wantplus &= ~vv;
      break;
    }
  }
  size = fread(buffer, 1, buffersize, ff);
  if (size < 32) {
    fprintf(stderr,"Error: lCFG block not found\n");
    return 5;
  }
  choices = (size / 4) - 3;
  for (ii = 0; ii <= choices; ++ ii) {
    at = ii * 4;
    if (buffer[at] == 0xEB && ! memcmp(&buffer[at + 2], "lCFG", 4)) {
      found = 1;
      break;
    }
  }
  if (! found) {
    fprintf(stderr,"Error: lCFG block not found\n");
    return 6;
  }
  if (buffer[at + 6] != '0' || buffer[at + 7] != '0') {
    fprintf(stderr,"Error: Unknown version lCFG block found\n");
    return 7;
  }
  if (0 == (buffer[at + 8 + 2] &  (1 << (offset - 16)) )) {
    fprintf(stderr,"Error: lCFG block found doesn't contain this configuration\n");
    return 8;
  }
  if (! query) {
    if (wantreplace) {
      buffer[at + offset] = want;
    }
    buffer[at + offset] |= wantplus;
    buffer[at + offset] &= ~wantminus;
    fseek(ff, 0, SEEK_SET);
    if (size != fwrite(buffer, 1, size, ff)) {
      fprintf(stderr,"Error: Failed to write file\n");
      return 9;
    }
    printf("Configuration updated\n");
  }
  {
    int value;
    value = buffer[at + offset];
    for (ii = 0; ii < (sizeof(names) / sizeof(names[0])); ++ ii) {
      printf("%s is %s\n", names[ii], value & (1 << ii) ? "ON" : "OFF");
    }
    for (; ii < 8; ++ ii) {
      if (value & (1 << ii)) {
        printf("Unknown flag %u is ON\n", 1 << ii);
      }
    }
  }
  return 0;
}
