#! /bin/bash

# Public Domain

if [ "$1" == "nopurge" ]
then
  shift
else
  hg purge --all -X 'doc/*'
fi

if nasm debmes.nas -fobj -l debmes.lst &&
  nasm debuasm.nas -fobj -l debuasm.lst &&
  nasm debasm.nas -fobj -l debasm.lst &&
  nasm debcom2.nas -fobj -l debcom2.lst &&
  nasm debcom1.nas -fobj -l debcom1.lst &&
  nasm debconst.nas -fobj -l debconst.lst &&
  nasm debdata.nas -fobj -l debdata.lst &&
  nasm debug.nas -fobj -l debug.lst &&
  nasm mzstack.nas -fobj
then
  [[ -z "$DOSEMU" ]] && DOSEMU=dosemu
  "$DOSEMU" -dumb -td -kt -quiet < /dev/null -K "$PWD" -E "lnk.bat"
  rm -rf debug.exe DEBUG.EXE
  convlist.pl debug.map debug.lst debasm.lst debcom1.lst debcom2.lst \
	debmes.lst debuasm.lst debconst.lst debdata.lst > debug.tls
fi
