;page 255,132

; Copyright (C) 1983 Microsoft Corp.
; Modifications copyright 2018 John Elliott
;           and copyright 2022 S. V. Nickolas.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the Software), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
; IN THE SOFTWARE.
;
; MS-DOS is a Registered Trademark of Microsoft Corp.

; DEBUG-86 8086 debugger runs under 86-DOS       version 2.30
;
; Modified 5/4/82 by AaronR to do all I/O direct to devices
; Runs on MS-DOS 1.28 and above
; REV 1.20
;       Tab expansion
;       New device interface (1.29 and above)
; REV 2.0
;       line by line assembler added by C. Peters
; REV 2.1
;       Uses EXEC system call
; REV 2.2
;       Ztrace mode by zibo.
;       Fix dump display to indent properly
;       Parity nonsense by zibo
;
; REV 2.3
;       Split into seperate modules to allow for
;       assembly on an IBM PC
;

          %include "debequ.mac"
          %include "dossym.mac"

code      segment   public 'code'
code      ends

const     segment   public word

          extrn     user_proc_pdb:word,stack:byte,cssave:word,dssave:word
          extrn     spsave:word,ipsave:word,linebuf:byte,qflag:byte
          extrn     newexec:byte,lbufsiz:byte,bacmes:byte
          extrn     badver:byte,endmes:byte,carret:byte,ptymes:byte
          extrn     badmem:byte
	extrn	createrr:byte, emptymessage:byte
	extrn	explicitcreatemessage:byte, alreadycreatedmessage:byte

%ifdef     help                          ; uso.
          extrn     helpmsg:byte,olhelp:byte
%endif

          extrn     dsiz:byte,noregl:byte,dispb:word

const     ends

data      segment   public word

          extrn     parserr:byte,dataend:word,ptyflag:byte,disadd:byte
          extrn     asmadd:byte,defdump:byte,bytebuf:byte
	extrn	diskpacket:byte, dp_sector_low:word, dp_sector_high:word
	extrn	dp_amount:word, dp_offset:word, dp_segment:word
	extrn	usepacket:byte, usefat32packet:byte

data      ends

dg        group     code,const,data


code      segment   public 'code'
assume    cs:dg,ds:dg,es:dg,ss:dg

          public    programloadname
          public    restart,set_terminate_vector,dabort,terminate,command
          public    find_debug,crlf,blank,tab,_out,inbuf,scanb,scanp
          public    printmes,rprbuf,hex,outsi,outdi,out16,digit,backup,rbufin

          extrn     perr:near,compare:near,dump:near,_enter:near,fill:near
          extrn     go:near,input:near,load:near,move:near,_name:near,kk:near
	extrn	kk_si:near
	extrn	closefile:near
          extrn     reg:near,search:near,dwrite:near,unassem:near,assem:near
          extrn     output:near,ztrace:near,trace:near,gethex:near,geteol:near

          extrn     defio:near,skip_file:near,debug_found:near
          extrn     trapparity:near,releaseparity:near
	extrn	saveints:near, restoreints:near

          org       100h
	times 256 nop			; NASM identicalise
..start:

programloadname label byte
start:
debug:    jmp short dstrt

	db 13,10
header:   db        "MSDebug release 4 by ecm"
          db        13,10,36,26		; EOF for type debug.com

dstrt:
	mov ax, 3306h			; DOS v5+ true version
	xor bx, bx			; preset
	int 21h
	xchg ax, bx
	test ax, ax			; supported ?
	jnz .true			; yes --?
	mov ax, 3000h			; DOS v2+ version
          int       21h
.true:
          xchg      ah,al               ; Turn it around to AH.AL
	xor bx, bx			; bl = 0, bh = 0
	cmp ax, 701h			; DOS > v7.00 ?
	jae okdosfat32packet
	cmp ax, 300h + 31		; DOS >= v3.31 ?
	jae okdospacket
          cmp       ax, 0200h           ; MS-DOS 2.0+?
          jae       okdos
          mov       dx,offset badver wrt dg
earlyerror:
std_con_string_output equ Std_Con_String_Output
          mov       ah,std_con_string_output
          int       21h
          mov ax, 4CFFh
          int 21h
          int       20h

okdosfat32packet:
	dec bh				; bh = FFh
okdospacket:
	dec bl				; bl = FFh
okdos:
	mov word [usepacket], bx	; also writes usefat32packet
%ifdef     help                          ; uso.
          mov       si, 80h
help2:    inc       si
          cmp       byte ptr [si], ' '
          je        help2
          cmp       byte ptr [si], 9
          je        help2
          cmp       word ptr [si], '/?'
          jne       nohelp
          mov       ah, std_con_string_output
          mov       dx, offset helpmsg wrt dg
          int       21h
          int       20h
nohelp:
%endif
          mov       dx,offset badmem wrt dg
	cmp sp, dataend
	jb earlyerror
          call      trapparity          ; scarf up those parity guys
get_current_pdb equ Get_Current_PDB
          mov       ah,get_current_pdb
          int       21h
          mov       [user_proc_pdb],bx  ; Initially set to DEBUG
          mov       sp,offset stack wrt dg
get_in_vars equ Get_In_Vars
          mov       ah,get_in_vars
          int       21h
gotlist:  mov       ax,cs
          mov       ds,ax
          mov       es,ax
          mov       dx,offset header wrt dg ; Code to print header
          call      rprbuf

	mov cl, 4
          mov       bx,offset dataend+15 wrt dg
          shr       bx, cl	; size of debug in paragraphs
	mov ah, 4Ah
	int 21h
	push ds
	call saveints
	sti
	pop ds
	mov si, 81h		; -> Debug command line tail
	call kk_si		; process it (used by create next)
	mov dx, offset emptymessage wrt dg
				; empty message if no error
	call create
          mov       ah,std_con_string_output
          int       21h
	jmp created

%if ($ - programloadname) lt 128
	db (128 - ($ - programloadname)) dup (90h)
%endif


create_failed:
	pop dx
	mov dx, offset createrr wrt dg
	ret

create:
	push dx
	push cs
	pop es
	push cs
	pop ds
          call      set_terminate_vector

%if        setcntc
          mov       al,23h              ; Set vector 23H
          mov       dx,offset dabort wrt dg
          int       21h
%endif

	mov ah, 48h
	mov bx, -1
	int 21h
	cmp bx, 20h			; need a bit of space for PSP + stack
	jb create_failed
	mov ah, 48h
	int 21h				; allocate largest
	jc create_failed
	mov dx, ax
	add ax, bx
	xchg si, ax			; => behind this memory block
	mov ah, 55h
	int 21h				; (takes PRA from int 22h vector)

	mov ds, dx			; => created PSP

		; copied from MISC.ASM
		; The FreeDOS kernel only writes si to the field
		;  at word [PSP:2]. MS-DOS before version 3 does
		;  not use the si input to 21.55 at all (instead
		;  calculating the word [PSP:6] based on what the
		;  word [PSP:2] already held).
		; So do it all manually here.
ENTRYPOINTSEG   EQU     0CH
MAXDIF          EQU     0FFFH

        MOV     [2], si		; set segment behind block
        ; SUB     AX,DX			; = amount of paragraphs allocated
	push bx
	xchg ax, bx			; = amount of paragraphs allocated
        CMP     AX,MAXDIF
        JBE     HAVDIF
        MOV     AX,MAXDIF		; consider at most 0FFFh paragraphs
HAVDIF:
	sub ax, 10h
		; This adjustment, which never underflows (as
		;  we allocated at least 11h paragraphs), is
		;  gleaned from a more recent MS-DOS kernel.
		; Perhaps it is meant to exclude part of the
		;  process segment from this size, for the stack.
		; The FreeDOS kernel happens to calculate the
		;  same values for a full (>= 64 KiB) segment,
		;  but its MAXDIF equivalent is 1000h and it
		;  subtracts 11h. Same difference. Reference:
		;  https://github.com/FDOS/kernel/blob/afe7fbe068bf7f3cc99dc01bf8e402311095757b/kernel/task.c#L540

        MOV     BX,ENTRYPOINTSEG	; = 0Ch
        SUB     BX,AX			; get segment for call 5 (underflows)
        MOV     CL,4
        SHL     AX,CL			; get offset for call 5
        MOV     WORD PTR [PDB_CPM_Call+1],AX
        MOV     WORD PTR [PDB_CPM_Call+3],BX
					; set call 5 address
        MOV     BYTE PTR [PDB_CPM_Call],mi_Long_CALL
					; build call 5 instruction
          mov       bx,cs
set_current_pdb equ Set_Current_PDB
          mov       ah,set_current_pdb
          int       21h
	pop bx				; = amount of paragraphs allocated

          mov       ax,dx
	dec ax
	mov ds, ax			; => MCB
	inc ax
	mov byte ptr [8], 0		; empty name
	mov word ptr [1], ax		; make it self owned
	push cs
	pop ds
	mov word ptr [user_proc_pdb], ax
          mov       di,offset dssave wrt dg
          cld
          stosw
          stosw
          stosw
          stosw
          mov       word ptr [disadd+2],ax
          mov       word ptr [asmadd+2],ax
          mov       word ptr [defdump+2],ax
          mov       ax,100h
          mov       word ptr [disadd],ax
          mov       word ptr [asmadd],ax
          mov       word ptr [defdump],ax
          mov       word ptr [ipsave],ax
          mov       ds,dx
          mov       dx,80h
set_dma equ Set_DMA
          mov       ah,set_dma
          int       21h                 ; Set default DMA address to 80H

	cmp bx, 1000h
	jb haveblock
	mov bx, 1000h			; bx = size in paragraphs clamped to 64 KiB
haveblock:
	mov cl, 4
	shl bx, cl			; (may overflow to zero)
	dec bx
	dec bx				; -> at the stack word to initialise
	and word ptr [bx], 0		; write a zero
	nop				; NASM identicalise
	mov byte ptr [100h], 0C3h
	push ds
	pop es

	push cs
	pop ds
	mov word ptr [spsave], bx	; initialise stack

	mov di, fcb			; es:di -> FCBs and command line tail
	mov si, di
	mov cx, (256 - fcb) / 2
	rep movsw			; transfer from Debug PSP

	push cs
	pop es

	pop dx
	ret

created:
          mov       ah,15               ; Get screen size and initialize display related variables
          int       10h
          cmp       ah,40
          jnz       parschk
          mov       byte [dsiz],7
          mov       byte [noregl],4
          mov       word [dispb],64
parschk:

          mov       di, offset programloadname - 1 wrt dg
filoop:   inc       di
          cmp       byte ptr [di],13 ; COMMAND LINE JUST SPACES?
          jz        command
          cmp       byte ptr [di],' '
          jz        filoop
          cmp       byte ptr [di],9
          jz        filoop
          call      defio               ; WELL READ IT IN
          mov       ax,[cssave]
          mov       word ptr [disadd+2],ax
          mov       word ptr [asmadd+2],ax
          mov       ax,[ipsave]
          mov       word ptr [disadd],ax
          mov       word ptr [asmadd],ax
	jmp command
	nop				; NASM identicalise

command_create:
	mov dx, offset emptymessage wrt dg

command_create_message:
	call create
command_message:
          mov       ah,std_con_string_output
          int       21h

command:  cld
          mov       ax,cs
          mov       ds,ax
          mov       es,ax
          mov       ss,ax
          mov       sp,offset stack wrt dg
          sti
	call closefile
          cmp       byte [ptyflag],0         ; did we detect a parity error?
          jz        goprompt            ; nope, go prompt
          mov       byte [ptyflag],0         ; reset flag
          mov       dx,offset ptymes wrt dg ; message to print
          mov       ah,std_con_string_output
          int       21h                 ; blam
goprompt: mov       al,prompt
          call      _out
          call      inbuf               ; Get command line

; From now and throughout command line processing, DI points
; to next character in command line to be processed.

          call      scanb               ; Scan off leading blanks
          jz        command             ; Null command?
	push ds
	call saveints
	sti
	pop ds
          lodsb                         ; AL=first non-blank character

; Prepare command letter for table lookup

%ifdef     help                          ; uso
          cmp       al,'?'
          jne       nothelp
          mov       dx, offset olhelp wrt dg
          mov       ah, std_con_string_output
          int       21h
          jmp short goprompt
nothelp:
%endif
	mov bx, 26 * 2			; default comtab entry for BU and ';'
	mov ah, byte ptr [si]
	cmp ax, "BU"
	je breakup
	cmp ax, "," + 0D00h
	je explicitcreate
	cmp al, ';'
	je command_dispatch
          sub       al,'A'              ; Low end range check
          jb        err1
          cmp       al,'Z'-'A'          ; Upper end range check
          ja        err1
          shl       al,1                ; Times two
          cbw                           ; Now a 16-bit quantity
          xchg      bx,ax               ; In BX we can address with it
	db 0A8h			; test al, imm8 (skip int 3)
breakup:
	int 3
command_dispatch:
          call      [cs:bx+comtab]      ; Execute command
          jmp       short command       ; Get next command
err1:     jmp       perr

explicitcreate:
	mov dx, offset alreadycreatedmessage wrt dg
	mov ax, cs
	cmp ax, word ptr [user_proc_pdb]
	jne command_message
	mov dx, offset explicitcreatemessage wrt dg
	jmp command_create_message

set_terminate_vector:
set_interrupt_vector equ Set_Interrupt_Vector
          mov       ax,(set_interrupt_vector << 8) | 22h  ; Set vector 22H
          mov       dx,offset terminate wrt dg
          int       21h
bu_ret:
          ret

terminate:
	call restoreints
          cmp       byte ptr [cs:qflag],0
          jnz       quiting
          mov       [cs:user_proc_pdb],cs
          cmp       byte ptr [cs:newexec],0
          jz        normterm
          mov       ax,cs
          mov       ds,ax
          mov       ss,ax
          mov       sp,offset stack wrt dg
          jmp       debug_found
normterm: mov       dx,offset endmes wrt dg
          mov       ax,cs
          mov       ds,ax
          mov       ss,ax
          mov       sp,offset stack wrt dg
          call      rprbuf
          jmp       command_create
exit equ Exit
quiting:  mov       ax,(exit << 8)
          int       21h
dabort:   mov       dx,offset carret wrt dg
restart:  mov       ax,cs
          mov       ds,ax
          mov       ss,ax
          mov       sp,offset stack wrt dg
          call      rprbuf
          jmp       command

; Get input line. Convert all characters NOT in quotes to upper case.

inbuf:    call      rbufin
          mov       si,offset linebuf wrt dg
          mov       di,offset bytebuf wrt dg
casechk:  lodsb
          cmp       al,'a'
          jb        noconv
          cmp       al,'z'
          ja        noconv
          add       al,'A'-'a'          ; Convert to upper case
noconv:   stosb
          cmp       al,13
          jz        indone
          cmp       al,'"'
          jz        quotscan
          cmp       al,"'"
          jnz       casechk
quotscan: mov       ah,al
killstr:  lodsb
          stosb
          cmp       al,13
          jz        indone
          cmp       al,ah
          jnz       killstr
          jmp short casechk
indone:   mov       si,offset bytebuf wrt dg
crlf:     mov       al,13               ; Output CR/LF sequence
          call      _out
          mov       al,10
          jmp       _out
backup:   mov       si,offset bacmes wrt dg ; Physical backspace - blank, backspace, blank

; Print ASCII message. Last char has bit 7 set

printmes: cs lodsb    ; Get char to print
          call      _out
          shl       al,1                ; High bit set?
          jnc       printmes
          ret

; Scan for parameters of a command

scanp:    call      scanb               ; Get first non-blank
          cmp       byte ptr [si],','   ; One comma between params OK
          jne       eolchk              ; If not comma, we found param
          inc       si                  ; Skip over comma

; Scan command line for next non-blank character

scanb:    push      ax
scannext: lodsb
          cmp       al,' '
          jz        scannext
          cmp       al,9
          jz        scannext
          dec       si                  ; Back to first non-blank
          pop       ax
eolchk:   cmp       byte ptr [si],13
          ret

; Hex addition and subtraction

hexadd:   mov       cx,4
          call      gethex
          mov       di,dx
          mov       cx,4
          call      gethex
          call      geteol
          push      dx
          add       dx,di
          call      out16
          call      blank
          call      blank
          pop       dx
          sub       di,dx
          mov       dx,di
          call      out16
          jmp short crlf

; Print the hex address of DS:SI

outsi:    mov       dx,ds               ; Put DS where we can work with it
          call      out16               ; Display segment
          mov       al,':'
          call      _out
          mov       dx,si
          jmp short out16               ; Output displacement

; Print hex address of ES:DI
; Same as OUTSI above

outdi:    mov       dx,es
          call      out16
          mov       al,':'
          call      _out
          mov       dx,di

; Print out 16-bit value in DX in hex

out16:    mov       al,dh               ; High-order byte first
          call      hex
          mov       al,dl               ; Then low-order byte

; Output byte in AL as two hex digits

hex:      mov       ah,al               ; Save for second digit
          push      cx                  ; Shift high digit into low 4 bits
          mov       cl,4
          shr       al,cl
          pop       cx
          call      digit               ; Output first digit
          mov       al,ah               ; Now do digit saved in AH
digit:    and       al,0fh              ; Mask to 4 bits
          add       al,90h              ; Trick 6-byte hex conversion works
          daa                           ;   on 8086 too.
          adc       al,40h
          daa

; Console output of character in AL. No registers affected but bit 7
; is reset before output.

_out:     push      dx
          push      ax
          and       al,7fh
          mov       dl,al
          mov       ah,2
          int       21h
          pop       ax
          pop       dx
          ret

rbufin:   push      ax
          push      dx
          mov       ah,10
          mov       dx,offset lbufsiz wrt dg
          int       21h
          pop       dx
          pop       ax
          ret

rprbuf:   mov       ah,9
          int       21h
          ret

blank:    mov       al," "              ; Output one space
          jmp       _out

tab:      call      blank               ; Output the number of blanks in CX
          loop      tab
          ret

; Command Table. Command letter indexes into table to get
; address of command. PERR prints error for no such command.

	even
comtab    dw        assem               ; A
          dw        perr                ; B
          dw        compare             ; C
          dw        dump                ; D
          dw        _enter              ; E
          dw        fill                ; F
          dw        go                  ; G
          dw        hexadd              ; H
          dw        input               ; I
          dw        perr                ; J
          dw        kk                  ; K
          dw        load                ; L
          dw        move                ; M
          dw        _name               ; N
          dw        output              ; O
          dw        ztrace              ; P
          dw        quit                ; Q (Quit)
          dw        reg                 ; R
          dw        search              ; S
          dw        trace               ; T
          dw        unassem             ; U
          dw        perr                ; V
          dw        dwrite              ; W
          dw        perr                ; X - uso will use for EMS
          dw        perr                ; Y
          dw        perr                ; Z
	dw bu_ret

quit:     inc       byte ptr [qflag]
          mov       bx,[user_proc_pdb]
find_debug:
          mov       ah,set_current_pdb
          int       21h
          call      releaseparity       ; let system do normal parity stuff
          mov       ax,(exit << 8)
          int       21h

code      ends
          end       start
