;page 255,132

; Copyright (C) 1983 Microsoft Corp.
; Modifications copyright 2018 John Elliott
;           and copyright 2022 S. V. Nickolas.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the Software), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
; IN THE SOFTWARE.
;
; MS-DOS is a Registered Trademark of Microsoft Corp.

%assign help	1			; enabled by ecm 2022-08-01

false     equ       0
true      equ       ~ false

          %include "dossym.mac"

firstdrv  equ       'A'

code      segment   public word 'code'
code      ends

const     segment   public word
const     ends

data      segment   public word
          extrn     ptyflag:byte
data      ends

dg        group     code,const,data

code      segment   public word 'code'
assume    cs:dg,ds:dg,es:dg,ss:dg

          extrn     rprbuf:near,restart:near
          public    drverr, trapparity, releaseparity, nmiint, nmiintend
trapparity:
          ret
releaseparity:
          ret

nmiint:
nmiintend:

drverr:
          push      cs
          pop       ds
          push      cs
          pop       es
          add       byte [drvlet],firstdrv
          mov       si,offset readm wrt dg
          mov       di,offset errtyp wrt dg
          mov       dx,offset disk wrt dg
write equ Write	; NASM port equate
          cmp       byte [rdflg],write
          jnz       movmes
          or        al,al
          jnz       savdrv
          mov       dx,offset wrtpro wrt dg
savdrv:
          mov       si,offset writm wrt dg
movmes:   movsw
          movsw
          call      rprbuf
          mov       dx,offset dskerr wrt dg
          jmp       restart
codeend:

code      ends


const     segment   public word

%ifdef     help
          public    olhelp
%endif
          public    endmes,carret,nambad,notfnd,noroom
          public    nospace,drvlet
          public    accmes
          public    toobig,synerr,errmes,bacmes
          public    exebad,hexerr,exewrt,hexwrt,wrtmes1,wrtmes2
          public    execemes, ptymes
	public	createrr, emptymessage
	public	explicitcreatemessage, alreadycreatedmessage
          extrn     rdflg:byte

endmes:   db        13,10,"Program terminated normally"
carret:   db        13,10,"$"
nambad:   db        "Invalid drive specification",13,10,"$"
notfnd:   db        "File not found",13,10,"$"
noroom:   db        "File creation error",13,10,"$"
nospace:  db        "Insufficient disk space",13,10,"$"

disk:     db        "Disk$"
wrtpro:   db        "Write protect$"
dskerr:   db        " error "
errtyp:   db        "reading drive "
drvlet:   db        "A",13,10,"$"
readm:    db        "read"
writm:    db        "writ"

toobig:   db        "Insufficient memory",13,10,"$"
synerr:   db        '^'
errmes:   db        " Error",13,10+80H
bacmes:   db        32,8+80h
exebad    label     byte
hexerr:   db        "Error in EXE or HEX file",13,10,"$"
exewrt    label     byte
hexwrt:   db        "EXE and HEX files cannot be written",13,10,"$"
wrtmes1:  db        "Writing $"
wrtmes2:  db        " bytes",13,10,"$"
execemes: db        "EXEC failure",13,10,"$"
createrr:	db "Unable to create child process, out of memory.",13,10,36
explicitcreatemessage:	db "Child process created.",13,10,36
alreadycreatedmessage:	db "A child process is already attached.",13,10
emptymessage:	db 36
accmes:   db        "Access denied",13,10,"$"
ptymes:   db        "Parity error or nonexistant memory error detected",13,10,"$"

%ifdef     help
olhelp:	db "MSDebug release 4 by ecm help screen",13,10
          db        "assemble     A [address]", 13, 10
          db        "compare      C range address", 13, 10
          db        "dump         D [range]", 13, 10
          db        "enter        E address [list]", 13, 10
          db        "fill         F range list", 13, 10
          db        "go           G [=address] [addresses]", 13, 10
          db        "hex          H value1 value2", 13, 10
          db        "input        I port", 13, 10
          db        "load         L [address [drive firstsector number]]", 13, 10
          db        "move         M range address", 13, 10
          db        "name         N [pathname] [arglist]", 13, 10
          db        "set command  K [pathname [arglist]]", 13, 10
          db        "output       O port byte", 13, 10
          db        "proceed      P [=address] [number]", 13, 10
          db        "quit         Q", 13, 10
          db        "register     R [register]", 13, 10
          db        "search       S range list", 13, 10
          db        "trace        T [=address] [number]", 13, 10
          db        "unassemble   U [range]", 13, 10
          db        "write        W [address [drive firstsector number]]", 13, 10
;         db        "allocate expanded memory        XA [#pages]", 13, 10
;         db        "deallocate expanded memory      XD [handle]", 13, 10
;         db        "map expanded memory pages       XM [Lpage] [Ppage] [handle]", 13, 10
;         db        "display expanded memory status  XS", 13, 10
          db        "$"
%endif

constend:

const     ends
          end
