#! /bin/bash

# Public Domain

[ -z "$DOSEMU" ] && DOSEMU=dosemu

if [ $# -lt 2 ]
then
	echo "Error: Expecting 2 pathname parameters!"
	exit 1
fi

sourcename="$1"
destname="$2"
trailing="${@:3}"

switches=""
while [[ "$1" == -* ]]
do
	if [[ "$1" == -- ]]
	then
		sourcename="$2"
		destname="$3"
		trailing="${@:4}"
		break
	fi
	switches="$switches $1"
	shift
	sourcename="$1"
	destname="$2"
	trailing="${@:3}"
done

if [ -n "$trailing" ]
then
	echo "Error: Trailing garbage. Expecting 2 pathname parameters!"
	exit 1
fi
if [ -z "$sourcename" ] || [ -z "$destname" ]
then
	echo "Error: Expecting 2 pathname parameters!"
	exit 1
fi

while [[ "$sourcename" == ../* ]] || [[ "$sourcename" == ./* ]] \
  || [[ "$destname" == ../* ]] || [[ "$destname" == ./* ]]
do
	while [[ "$sourcename" == ./* ]] || [[ "$destname" == ./* ]]
	do
		sourcename="${sourcename#./}"
		destname="${destname#./}"
	done
	if [[ "$sourcename" == ../* ]] && [[ "$destname" == ../* ]]
	then
		sourcename="${sourcename#../}"
		destname="${destname#../}"
		cd ..
	elif [[ "$sourcename" == ../* ]]
	then
		sourcename="${sourcename#../}"
		prepend="$(basename "$PWD")"
		destname="$prepend/$destname"
		cd ..
	elif [[ "$destname" == ../* ]]
	then
		destname="${destname#../}"
		prepend="$(basename "$PWD")"
		sourcename="$prepend/$sourcename"
		cd ..
	fi
done

set -- "$sourcename" "$destname"
param=" ${*//\//\\}"
param="${param// \\/ \/}"
echo "$DOSEMU" -dumb -td -kt -q -quiet -K "$PWD" -E "lzexedat $switches -- $param"
"$DOSEMU" < /dev/null -dumb -td -kt -q -quiet -K "$PWD" -E "lzexedat $switches -- $param"
