{$A+,B-,D+,F-,I-,O-,R-,S-,V+}
{$IFNDEF FPC}
{$E+,N-,L+}
{$ENDIF}
{$M 4096,0,0}
{ display information of an EXE file }
program infoexe;

uses cmdline,FreeWare;

type
	Thexw=string[4];
	ThexL=string[8];
	Tstr=string[80];

const
	wexeSignature = 0;
	wexeExtraBytes = 1;
	wexePages = 2;
	wexeRelocItems = 3;
	wexeHeaderSize = 4;
	wexeMinAlloc = 5;
	wexeMaxAlloc = 6;
	wexeInitSS = 7;
	wexeInitSP = 8;
	wexeChecksum = 9;
	wexeInitIP = 10;
	wexeInitCS = 11;
	wexeRelocTable = 12;
	wexeOverlayNum = 13;
	WEXESIZE = 14;
	BEXESIZE = WEXESIZE * 2;
	HexStr:array[0..15] of char='0123456789ABCDEF';

procedure emptyline;
begin
	{ writeln; }
end;

function HexW(a:word):Thexw;
var
	s:ThexW;
	i:byte;

begin
	s[0]:=#4;
	for i:=4 downto 1 do begin
		s[i]:=HexStr[byte(a) and $F];
		a:=a shr 4;
	end;
	HexW:=s;
end;

function HexL(a:longint):ThexL;
var
	s:ThexL;
	i:byte;

begin
	s[0]:=#8;
	for i:=8 downto 1 do begin
		s[i]:=HexStr[byte(a) and $F];
		a:=a shr 4;
	end;
	HexL:=s;
end;


procedure help;
begin
	Writeln('Syntax: INFOEXE filename[.EXE]');
	Coordonnees;
	halt(0);
end;

procedure Fatal(s:Tstr);
begin
	Writeln;
	writeln;
	writeln('INFOEXE: Fatal Error: '+s);
	Writeln;
	halt(255);
end;

procedure IOtest;
var e:integer;
begin
	e:=IOresult;
	if e<>0 then Fatal(ErrorMsg(e));
end;

procedure Write3(a,b,c:Tstr);
begin
	while length(a)<35 do a:=a+' ';
	Writeln(a,b:15,c:15);
end;

procedure WriteW(s:Tstr;a:word);
var b:string[5];
begin
	str(a,b);
	Write3(s,b,HexW(a));
end;

procedure WriteL(s:Tstr;a:longint);
var b:string[10];
begin
	str(a,b);
	Write3(s,b,HexL(a));
end;

procedure WriteDD(s:Tstr;h,l:word);
begin
	Write3(s,'',HexW(h)+':'+HexW(l));
end;


var
	NomEXE:string[80];
	f:file;
	Hexe:array[0..15] of word;
	imageplusheadersize,size,headersize,imagesize,
	amountpages,imagesizepara:longint;

begin
	Writeln('INFOEXE.EXE  (C) 1989 Fabrice BELLARD, ecm release 4');
	Writeln('Information of an EXE file');
	emptyline;

	NomExe:=GetUpCase;
	if NomExe='' then help;
	if pos('.',NomExe)=0 then NomExe:=NomExe+'.EXE';

	assign(f,NomExe);
	reset(f,1);
	IOtest;
	BlockRead(f,Hexe,32);
	IOtest;
	size:=FileSize(f);
	Close(f);
	IOtest;
	if ((Hexe[wexeSignature] <> $5A4D) and (Hexe[wexeSignature]<>$4D5A)) then
	  Fatal('The file is not an EXE file');

	amountpages := longint(Hexe[wexePages]);
	if (amountpages = 0) then
	  Fatal('Invalid EXE file, zero pages');
	imageplusheadersize:= (amountpages - 1) * 512;
	if ((Hexe[wexeExtraBytes] = 0) or (Hexe[wexeExtraBytes] > 512)) then
	  inc(imageplusheadersize,512)
	else
	  inc(imageplusheadersize,Hexe[wexeExtraBytes]);

	Writeln('Examining ',NomExe);
	emptyline;
	if (Hexe[wexeExtraBytes] > 512) then begin
		Writeln('Invalid last page bytes field! Got '
			+HexW(Hexe[wexeExtraBytes])+'h');
		emptyline;
	end;

	Write3('','Decimal','Hex');
	emptyline;

	headersize := Longint(Hexe[wexeHeaderSize]) * 16;
	imagesize := imageplusheadersize - headersize;
	imagesizepara := (imagesize + 15) div 16;

	WriteL('Length on disk (bytes)',size);
	WriteL('Length of header + image (bytes)',imageplusheadersize);
	if imageplusheadersize<>size then
	  Writeln('The file seems to contain internal overlays.');
	emptyline;
	WriteL('Image size (paragraphs)',imagesizepara);
	WriteL('Image size (bytes)',imagesize);
	emptyline;
	WriteW('Minimum alloc (paragraphs)',Hexe[wexeMinAlloc]);
	WriteL('Minimum alloc (bytes)',Longint(Hexe[wexeMinAlloc]) * 16);
	WriteW('Maximum alloc (paragraphs)',Hexe[wexeMaxAlloc]);
	WriteL('Maximum alloc (bytes)',Longint(Hexe[wexeMaxAlloc]) * 16);
	emptyline;

	WriteW('Minimum alloc incl image (paras)',Hexe[wexeMinAlloc] + imagesizepara);
	WriteL('Minimum alloc incl image (bytes)',(Longint(Hexe[wexeMinAlloc]) + imagesizepara) * 16);
	if (Hexe[wexeMaxAlloc] = $FFFF) then begin
		Write3('Maximum alloc incl image (paras)','','unlimited');
		Write3('Maximum alloc incl image (bytes)','','unlimited');
	end else if ((Hexe[wexeMaxAlloc] + imagesizepara) >= $FFFF) then begin
		Write3('Maximum alloc incl image (paras)','','unlimited (not FFFFh)');
		Write3('Maximum alloc incl image (bytes)','','unlimited (not FFFFh)');
	end else begin
		WriteW('Maximum alloc incl image (paras)',Hexe[wexeMaxAlloc] + imagesizepara);
		WriteL('Maximum alloc incl image (bytes)',(Longint(Hexe[wexeMaxAlloc]) + imagesizepara) * 16);
	end;
	emptyline;
	WriteDD('SS:SP',Hexe[wexeInitSS],Hexe[wexeInitSP]);
	WriteDD('CS:IP',Hexe[wexeInitCS],Hexe[wexeInitIP]);
	emptyline;
	WriteW('Amount relocation entries',Hexe[wexeRelocItems]);
	WriteW('Base of relocation entry table',Hexe[wexeRelocTable]);
	WriteW('Header size (paragraphs)',Hexe[wexeHeaderSize]);
	WriteL('Header size (bytes)',Longint(Hexe[wexeHeaderSize]) * 16);
	emptyline;
	WriteW('Overlay number',Hexe[wexeOverlayNum]);
	emptyline;
end.
