;    File              : $INIT.ASM$
;
;    Description       :
;
;    Original Author   : DIGITAL RESEARCH
;
;    Last Edited By    : $CALDERA$
;
;-----------------------------------------------------------------------;
;    Copyright Work of Caldera, Inc. All Rights Reserved.
;      
;    THIS WORK IS A COPYRIGHT WORK AND CONTAINS CONFIDENTIAL,
;    PROPRIETARY AND TRADE SECRET INFORMATION OF CALDERA, INC.
;    ACCESS TO THIS WORK IS RESTRICTED TO (I) CALDERA, INC. EMPLOYEES
;    WHO HAVE A NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF
;    THEIR ASSIGNMENTS AND (II) ENTITIES OTHER THAN CALDERA, INC. WHO
;    HAVE ACCEPTED THE CALDERA OPENDOS SOURCE LICENSE OR OTHER CALDERA LICENSE
;    AGREEMENTS. EXCEPT UNDER THE EXPRESS TERMS OF THE CALDERA LICENSE
;    AGREEMENT NO PART OF THIS WORK MAY BE USED, PRACTICED, PERFORMED,
;    COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
;    CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;    TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF
;    CALDERA, INC. ANY USE OR EXPLOITATION OF THIS WORK WITHOUT
;    AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
;    CIVIL LIABILITY.
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log$
;    INIT.ASM 1.25 93/12/07 15:51:27
;    Move int13pointer to offset 0B4h as some app expects it there
;    INIT.ASM 1.24 93/11/18 18:57:20
;    Increase amount reserved for COMMAND.COM by 256 bytes
;    INIT.ASM 1.23 93/11/17 19:29:26
;    Change default DEBLOCK seg to FFFF for performance reasons
;    INIT.ASM 1.19 93/07/22 19:43:59 
;    switch over to REQUEST.EQU
;    ENDLOG

	%include "lmacros2.mac"

	%include "biosgrps.mac"
	%include "config.mac"
	%include "drmacros.mac"
	%include "ibmros.mac"
	%include "msdos.mac"
	%include "request.mac"		; request header equates
	%include "bpb.mac"
	%include "udsc.mac"
	%include "driver.mac"
	%include "keys.mac"		; common key definitions


section ENDCODE
ENDCODE_start:
section DATAEND
DATAEND_start:
section IDATA
IDATA_start:
section INITDATA
INITDATA_start:
section RCODE
RCODE_start:
section RESBIOS
RESBIOS_start:
section RESUMECODE
RESUMECODE_start:


; IBM AT Hardware equates

;COMPRESSED	equ	FALSE		; enables compressed changes.

; a little macro to help locate things
; it warns us when the ORG get trampled on
%macro orgabs 2.nolist
 %assign %%was ($ - $$)
 %assign %%is %1
 %if %%was > %%is
  %warning absolute data overwritten !! moving it: %2
 %else
	org %1
 %endif
%endmacro

%macro jmpfar 2.nolist
	db	0EAh		; jmpf opcode
	dw	offset %1 wrt CGROUP	; offset of destination
%2:	dw	0EDCh		; segment of destination
%endmacro

%macro callfar 2.nolist
	db	09Ah		; callf opcode
	dw	offset %1 wrt CGROUP	; offset of destination
%2:	dw	0EDCh		; segment of destination
%endmacro

F5KEY		equ	3F00h
F8KEY		equ	4200h

SWITCH_F	equ	01h

absolute 0

		org	0000h*4, db ?
i0off		dw	?
i0seg		dw	?

		org	0001h*4, db ?
i1off		dw	?
i1seg		dw	?

		org	0003h*4, db ?
i3off		dw	?
i3seg		dw	?

		org	0004h*4, db ?
i4off		dw	?
i4seg		dw	?

		org	0015h*4, db ?
i15off		dw	?
i15seg		dw	?

		org	0019h*4, db ?
i19off		dw	?
i19seg		dw	?

		org	001Eh*4, db ?
i1Eptr		label	dword
i1Eoff		dw	?
i1Eseg		dw	?

		org	002Fh*4, db ?
i2Fptr		label	dword
i2Foff		dw	?
i2Fseg		dw	?

		org	006Ch*4, db ?
i6Cptr		label	dword
i6Coff		dw	?
i6Cseg		dw	?

IVECT	ends

group CGROUP CODE RCODE ICODE INITDATA

section CODE public align=2 class=CODE

	Assume	CS:CGROUP, DS:Nothing, ES:Nothing, SS:Nothing

	public	strat
%if SVARDOS
	public	kernflg
	public COMPRESS_FROM_HERE
%endif

	extrn	ConsoleTable:word
	extrn	ClockTable:word
	extrn	SerParCommonTable:word
	extrn	DiskTable:near
	extrn	Int13Deblock:near
	extrn	Int13Unsure:near
	extrn	Int2FHandler:near
	extrn	ResumeHandler:near

	extrn	biosinit_end:byte	; End of the BIOS Init Code and Data
	extrn	biosinit:near
	
	extrn	rcode_fixups:word
	extrn	rcode_seg:word
	extrn	rcode_offset:word
	extrn	rcode_len:word
	extrn	icode_len:word
	extrn	current_dos:word
	extrn	device_root:dword
	extrn	mem_size:word
	extrn	ext_mem_size:word
	extrn	init_buf:byte
	extrn	init_drv:byte
	extrn	init_int13_unit:byte
	extrn	init_runit:byte
	extrn	comspec_drv:byte
	extrn	init_flags:word


%include "biosmsgs.mac"			; Include TFT Header File

	Public	A20Enable
A20Enable proc near
;========
; This location is fixed up at run time to be a RET
; If the BIOS is relocated to the HMA then it is fixed up again to be
; CALLF IBMDOS:A20Enable; RET
; Calling this location at run time will ensure that the HMA is mapped
; in so we can access the HMA code.
;
A20Enable endp

init	proc	near			; this is at BIOSCODE:0000h
	jmp	init0			; jump to zero-decompression stage
init	endp

%if SVARDOS
; start offset of zero-compressed file area
compstart	dw	offset COMPRESS_FROM_HERE wrt CGROUP	

; kernel flags:
;   bit 0: set if assembled for compression
;   bit 1: set if assembled for single-file kernel
;   bit 7: set after kernel was processed by COMPBIOS and COMPKERN

;   bit 2: if set, gives debugger a chance to intercept by calling INT 3
;	   CAUTION: breaks original IBM-PC compatibility if not run under
;	            debugger
; As of the lCFG block use in 2024 September this debugger check flag
;  is no longer used from the kernel flags. Use lDOS patchini/patchdeb
;  to modify the check debugger byte in the lCFG block instead.
kernflg		db	(SINGLEFILE << 1) + COMPRESSED
%else
init0 equ init1

compflg	label	word
	dw	offset INITDATA_start wrt CGROUP	; compresses from INITDATA onwards
%endif					; this word set to 0 when compressed

	org	06h

	db	'COMPAQCompatible'  
	dw	offset RCODE_start wrt CGROUP	; lets find offset of RCODE
MemFixup dw	0			;  and its relocated segment	


	Public	cleanup
cleanup	PROC	far			; BIOSINIT will call here later
	ret
cleanup	endp


;	Device driver headers for serial/parallel devices

con_drvr	dw	offset aux_drvr, 0	; link to next device driver
		dw	DA_CHARDEV+DA_SPECIAL+DA_ISCOT+DA_ISCIN+DA_IOCTL
		dw	offset strat, offset IntCon
		db	'CON     '
		db	'COLOUR'
col_mode	db	0,7,0

	%imacro dump_aux_prn_drvr 0
		dw	offset prn_drvr, 0		; link to next device driver
		dw	DA_CHARDEV
		dw	offset strat, offset IntCOM1
		db	'AUX     '

		dw	offset clock_drvr, 0	; link to next device driver
		dw	DA_CHARDEV
		dw	offset strat, offset IntLPT1
		db	'PRN     '
	%endmacro
aux_drvr: equ $
prn_drvr: equ $ + 18

%if SVARDOS
aux_prn_drvr_destination:

	%imacro lcfgoption 3+.nolist
	_fill %1, 0, lcfg
%%start:
	%2
	%3
%%end:
%assign %%index %%start - lcfg
%rep %%end - %%start
%assign LCFGINUSE LCFGINUSE | (1 << %%index)
 %assign %%index %%index + 1
%endrep
	%endmacro
%assign LCFGINUSE 0

	align 4, db 0
lcfg:
.:		jmp strict short .end
lcfgoption 2,,	db "lCFG"
lcfgoption 6,,	db "00"
lcfgoption 8,,	dq .inuse

%include "../tmp/edrdosl.mac"

lcfgoption 32,,
.end:
.size: equ .end - .
.inuse equ LCFGINUSE

	_fill 18 * 2, 0, aux_prn_drvr_destination
aux_prn_drvr_size equ $ - aux_prn_drvr_destination
%else
	dump_aux_prn_drvr
%endif

clock_drvr	dw	disk_drvr, 0		; link to next device driver
		dw	DA_CHARDEV+DA_ISCLK
		dw	offset strat, offset IntClock
		db	'CLOCK$  '

com1_drvr	dw	offset lpt1_drvr, 0		; link to next device driver
		dw	DA_CHARDEV
		dw	offset strat, offset IntCOM1
		db	'COM1    '

com2_drvr	dw	offset com3_drvr, 0		; link to next device driver
		dw	DA_CHARDEV
		dw	offset strat, offset IntCOM2
		db	'COM2    '

com3_drvr	dw	offset com4_drvr, 0		; link to next device driver
		dw	DA_CHARDEV
		dw	offset strat, offset IntCOM3
		db	'COM3    '

%IFDEF EMBEDDED
	extrn	rdisk_drvr:near
com4_drvr	dw	offset rdisk_drvr, 0	; link to next device driver
%ELSE		
com4_drvr	dw	-1, -1			; link to next device driver
%ENDIF	
		dw	DA_CHARDEV
		dw	offset strat, offset IntCOM4
		db	'COM4    '


	orgabs	0b4h, i13pointer	; save address at fixed location
					;  for dirty apps

	Public	i13pointer, i13off_save, i13seg_save

i13pointer	label	dword		; address of ROS Int 13h entry
i13off_save	dw	?
i13seg_save	dw	?


	orgabs	0b8h, req_ptr		; REQ_HDR

	public	req_ptr, req_off, req_seg

req_ptr	label	dword
req_off	dw	0			;** fixed location **
req_seg	dw	0			;** fixed location **

;	Local single character buffer for Ctrl-Break handling
	public	serparFlag, serparChar

serparFlag	db	4 dup (FALSE)	; we haven't got any yet
serparChar	db	4 dup (?)	; will store one character

lpt1_drvr	dw	offset lpt2_drvr, 0		; link to next device driver
		dw	DA_CHARDEV
		dw	offset strat, offset IntLPT1
		db	'LPT1    '


lpt2_drvr	dw	offset lpt3_drvr, 0		; link to next device driver
		dw	DA_CHARDEV
		dw	offset strat, offset IntLPT2
		db	'LPT2    '

lpt3_drvr	dw	offset com2_drvr, 0		; link to next device driver
		dw	DA_CHARDEV
		dw	offset strat, offset IntLPT3
		db	'LPT3    '

	orgabs	100h, vecSave		; save vectors at fixed location
					;  for dirty apps

	Public	orgInt13

vecSave		db	10h
		dw	0,0
		db	13h
orgInt13	dw	0,0
		db	15h
		dw	0,0
		db	19h
		dw	0,0
		db	1Bh
		dw	0,0

NUM_SAVED_VECS	equ	($ - vecSave) / 5

strat	proc	far
	mov	[cs:req_off],bx
	mov	[cs:req_seg],es
	ret
strat	endp

Int19Trap:
	cld
	cli				; be sure...
	push	cs
	pop	ds
	mov	si, offset vecSave
	mov	cx,NUM_SAVED_VECS	; restore this many vectors
Int19Trap10:
	xor	ax,ax			; zero AH for lodsb
	mov	es,ax			; ES -> interrupt vectors
	lodsb				; AX = vector to restore
	shl	ax,1
	shl	ax,1			; point at address
	xchg	ax,di			; ES:DI -> location to restore
	movsw
	movsw				; restore this vector
	loop	Int19Trap10		; go and do another
	cmp	word ptr [oldxbda],0	; has the XBDA been moved?
	 je	Int19Trap20		; no
	mov	ax,word ptr [oldmemtop]; also restore old conventional
					; memory top
	mov	es,word ptr [oldxbda]; yes, move it back
	mov	cx,word ptr [xbdalen]
	mov	ds,word ptr [newxbda]
	xor	si,si
	xor	di,di
	rep	movsw
	mov	ds, cx			; => segment 0
	mov	word ptr [40Eh], es
	mov	word ptr [413h], ax
					; update BIOS data
Int19Trap20:
	int	19h			; and go to original int 19...

	even
	Public	oldxbda,newxbda,xbdalen,oldmemtop
oldxbda		dw	0		; old XBDA segment address
newxbda		dw	0		; new XBDA segment address
xbdalen		dw	0		; length of XBDA in words
oldmemtop	dw	0		; old conventional mem limit

	orgabs	16ch, devno		; PRN:/AUX: the device number

devno	db	0,0			;** fixed location **

	Public	NumDiskUnits, DeblockSeg

disk_drvr	dw	offset com1_drvr, 0	; link to next driver
		dw	DA_NONIBM+DA_GETSET+DA_REMOVE+DA_BIGDRV
		dw	offset strat, offset IntDisk
NumDiskUnits	db	5, 7 dup (?)
		dw	0EDCh		; checked by DRIVER.SYS
		dw	0		; was allocate UDSC
DeblockSeg	dw	0A000h		; segment we start deblocking


IntLPT1:				; LPT1
	call	DeviceDriver
	dw	0

IntLPT2:				; LPT2
	call	DeviceDriver
	dw	1

IntLPT3:				; LPT3
	call	DeviceDriver
	dw	2

IntCOM1:				; AUX = COM1
	call	DeviceDriver
	dw	3

IntCOM2:				; COM2
	call	DeviceDriver
	dw	4

IntCOM3:				; COM3
	call	DeviceDriver
	dw	5

IntCOM4:				; COM4
	call	DeviceDriver
	dw	6

IntCon:
	call	DeviceDriver
	dw	offset ConsoleTable

IntClock:
	call	DeviceDriver
	dw	offset ClockTable

	Public	IntDiskTable
IntDisk:
	call	DeviceDriver
IntDiskTable:
	dw	offset DiskTable

DeviceDriver	proc	near
	call	A20Enable		; make sure A20 is on
	jmpfar	DriverFunction, DriverFunctionFixup
DeviceDriver	endp

	extrn	i13_AX:word

	Public	Int13Trap

Int13Trap	proc	far
;--------
; The Int 13 code is in low memory for speed, with unusual conditions
; having the overhead of A20Enable calls
;
	cmp	ah,ROS_FORMAT		; ROS format function?
	 je	Int13TrapFormat
Int13Trap10:
	mov	[cs:i13_AX],ax		; save Op/Count in case of error
	clc
	pushf				; fake an Int
	call	far [cs:i13pointer]		; call the ROM BIOS
	 jc	Int13Trap20		; check for error
	ret	2			; none, so return to caller
Int13Trap20:
	cmp	ah,9			; it it a DMA error ?
	 je	Int13TrapDMA		;  then deblock it
	call	Int13TrapUnsure		; else declare floppy drive unsure
	stc				; restore error flag
	ret	2			; return to user

Int13TrapFormat:
	call	Int13TrapUnsure		; mark media as unsure
	jmps	Int13Trap10		;  and resume

Int13TrapDMA:
	call	A20Enable		; make sure A20 is on
	jmpfar	Int13Deblock, Int13DeblockFixup

Int13TrapUnsure proc near
	call	A20Enable		; make sure A20 is on
	callfar	Int13Unsure, Int13UnsureFixup
	ret
Int13TrapUnsure	endp

Int13Trap	endp


	Public	Int2FTrap

Int2FTrap	proc	far
;--------
	jmpfar	Int2FHandler, Int2FFixup
Int2FTrap	endp


Resume	proc	far
;-----
	call	A20Enable		; make sure A20 is on
	jmpfar	ResumeHandler, ResumeFixup
Resume	endp

Int0Trap proc	far
;-------
	call	A20Enable		; make sure A20 is on
	jmpfar	Int0Handler, Int0Fixup
Int0Trap endp

	Public	FastConsole

FastConsole  proc   far
;----------
; RAM entry to ensure INT29 vector is below INT20 vector
; We keep the normal path low to maxmimise performance, but on backspace we
; take the A20Enable hit and call high for greater TPA.
;
	pushx	<ax, bx, si, di, bp>	; old ROS corrupts these
	cmp	al,8			; back space character
	 je	Fastcon30		; special case
Fastcon10:
	push	es
	push	cx
	mov	cx,40h
	mov	es,cx
	mov	bx,word ptr [cs:col_mode]	; get colour mode
	xchg	bh,bl
	cmp	bh,0			; check if COLOUR is active
	 je	Fastcon15		; no, continue normally
	cmp	al,7			; check for non-printable chars
	 je	Fastcon15
	cmp	al,0ah
	 je	Fastcon13
	cmp	al,0dh
	 je	Fastcon15
	xor	bh,bh			; assume video page 0
	mov	ah,9
	mov	cx,1			; one char to display
	int	10h			; display char with given colour
	mov	bl,ah
	mov	ah,3
	int	10h
	inc	dl
	cmp	dl,[es:4ah]
	 jb	Fastcon12
	xor	dl,dl
Fastcon11:
	inc	dh
	cmp	dh,[es:84h]
	 jbe	Fastcon12
	dec	dh
	push	dx
	mov	ax,601h
	xor	cx,cx
	mov	dl,[es:4ah]
	dec	dl
	mov	dh,[es:84h]
	mov	bh,byte ptr [cs:col_mode+1]
	int	10h
	pop	dx
Fastcon12:
	mov	ah,2
	mov	bh,[es:62h]
	int	10h
	jmps	Fastcon20
Fastcon13:
	mov	ah,3
	xor	bh,bh
	int	10h
	jmps	Fastcon11
Fastcon15:
	mov	ah,0eh			; use ROS TTY-like output function
	mov	bx,7			; use the normal attribute
	int	VIDEO_INT		; output the character in AL
Fastcon20:
	pop	cx
	pop	es
	popx	<bp, di, si, bx, ax>
	iret

Fastcon30:
	call	A20Enable		; make sure A20 is on
	jmpfar	OutputBS, OutputBSFixup	; call up to the HMA

FastConsole endp

	Public	ControlBreak
ControlBreak:

;-----------
	mov	word [cs:local_char],'C'-40h + (256*TRUE)
;;	mov	local_char,'C'-40h	; force ^C into local buffer
;;	mov	local_flag,TRUE		; indicate buffer not empty
Int1Trap:
Int3Trap:
Int4Trap:
	iret

	even
	public	daycount
daycount	dw	0



; More Disk Data

	public	local_buffer,local_id,local_pt


		even

%if SVARDOS
; DRBIO/DRKERNEL uncompression and relocation stage. This is executed right
; after the jump at the beginning of the CODE segment. This area is shared
; with the 512 byte deblocking buffer and gets eventually overwritten.
;
; If the kernel is not loaded to segment 70h it is relocated to it.

init0	proc near

local_buffer 	label 	byte

	mov	byte [cs:A20Enable],0C3h ; fixup the RET
	mov	si,TEMP_RELOC_SEG - 41h	; stack right below relocation
	mov	ss,si			; segment with 16 bytes safety
	mov	sp,400h			; distance

	sti
	cld

	; The following expects ds:bp to point to the boot sector, in
	; particular the BPB, to push its hidden sectors field to stack.
	; It is used to determine the boot drive by matching the
	; partition offset.
	push	word [ds:1eh + bp]		; push BPB hidden sectors
	push	word [ds:1ch + bp]		; ..popped at init0 end

	push	cx			; save entry registers
	push	di			; (important in ROM systems)

	xor	si,si
	mov	ds,si
	mov	es,si

	Assume	DS:IVECT, ES:IVECT

	; Copy diskette parameters (11 bytes) from the location stored
	; at INT1E over to 0000:0522. This MAY previously be located at 7C00
	; or another (non-)BIOS location depending on the boot sector code.
	; After copying, set INT1E to point to the new location.

	mov	di,522h			; ES:DI -> save area for parameters
	lds	si,[i1Eptr]		; DS:SI -> FD parameters for ROS

	Assume	DS:Nothing

	mov	[es:i1Eoff],di
	mov	[es:i1Eseg],es		; setup new location
	mov	cx,11
	rep	movsb
	mov	byte ptr [es:di-7],36	; enable read/writing of 36 sectors/track

	pop	di
	pop	cx

	push	ax			; ROM boot: BDOS seg
	mov	ax, cs			; preserve entry registers
	mov	ds, ax			; other than si, ds and es
	xor	si, si

	; determine which register holds the boot drive unit
	; EDR load protocol: CS=70h, DL=unit
	; FreeDOS load protocol: CS=60h, BL=unit
	; standardize to DL holding drive unit
	cmp	ax,60h			; are we loaded at segment 60h?
	jne	uncompress_and_relocate_kernel
	mov	dl,bl			; copy phys boot drive fron BL to DL

uncompress_and_relocate_kernel:
%if COMPRESSED eq 0
	; if kernel is uncompressed and we live at the correct segment, then
	; skip whole uncompression and relocation
	push	cs
	pop	ax
	cmp	ax,BIO_SEG
	jne	@F
	jmp	not_compressed
@@:
%endif
	push	di			; ROM boot: DL=0ffh, Disk boot: DL=phys boot drv
	push	bx			; ROM boot: memory size, Disk boot: unused
	push	cx			; ROM boot: initial drives, Disk boot: unused
	push	dx			; ROM boot: BIO seg, Disk boot: unused

	mov	ax,TEMP_RELOC_SEG
	mov	es,ax
%if (SINGLEFILE eq 1) | (COMPRESSED eq 1)
	; determine kernel file size in words
	; this is set by COMPBIOS and COMPKERN tools
	mov	ax,[cs:kernel_size]
%else
	 ; for an uncompressed DRBIO.SYS we must determine kernel_size, as
	 ; neither COMPBIO or COMPKERN are run on this (kernel_size=0)
	mov	ax,offset DATAEND_start wrt CGROUP
	shr	ax,1
	mov	[cs:kernel_size],ax
%endif
	; we now copy up to 128K to TEMP_RELOC_SEG for relocation
	; and / or uncompression
	call	copywords

	; we now far jmp to our kernel copy at TEMP_RELOC_SEG
	db	0eah
	dw	@@farjmp_tmp_seg,TEMP_RELOC_SEG	
 @@farjmp_tmp_seg:

  	mov	ax,TEMP_RELOC_SEG
  	mov	ds,ax
  	mov	ax,BIO_SEG
  	mov	es,ax

%if COMPRESSED eq 1
  	; copy uncompressed part of compressed DRBIO / KERNEL to BIO_SEG
  	mov	ax, offset COMPRESS_FROM_HERE
  	inc	ax
  	shr	ax,1
%else
  	; copy whole kernel if uncompressed
  	mov	ax,[cs:kernel_size]
%endif
	call	copywords

	; we now far jmp to ourself at BIO_SEG
	db	0eah
	dw	@@farjmp_bio_seg,BIO_SEG	
@@farjmp_bio_seg:

%if COMPRESSED eq 1
	; now decompress the compressed part of DRBIO/KERNEL
	mov	si, offset COMPRESS_FROM_HERE
	mov	di,si
@@uncompress_block:
	mov	cl,4
	mov	bx,ds			; canonicalize ds:si
	mov	ax,si			; to support kernel images >64K
	shr	ax,cl			; and make sure we do not wrap around
	add	ax,bx			; at segment boundary while
	mov	ds,ax			; uncompressing
	and	si,0fh
	mov	bx,es			; canonicalize es:di
	mov	ax,di			; to support kernel images >64K
	shr	ax,cl			; and make sure we do not wrap around
	add	ax,bx			; at segment boundary while
	mov	es,ax			; uncompressing
	and	di,0fh
	lodsw				; get control word
	mov	cx,ax			; as a count
	jcxz	@@uncompress_fini	; all done
	test	cx,8000h		; negative ?
	jnz	@@uncompress_zeros	; yes do zeros
	rep	movsb			; else move in data bytes
	jmp 	@@uncompress_block	; and to the next
@@uncompress_zeros:
	and	cx,7fffh		; remove sign
	jcxz	@@uncompress_block	; none to do
	xor	ax,ax
	rep	stosb			; fill with zeros
	jmp 	@@uncompress_block
@@uncompress_fini:
%endif
	pop	dx			; ROM boot: DL=0ffh, Disk boot: DL=phys boot drv
	pop	cx			; ROM boot: memory size, Disk boot: unused
	pop	bx			; ROM boot: initial drives, Disk boot: unused
	pop	di			; ROM boot: BIO seg, Disk boot: unused
not_compressed:
	pop	ax			; ROM boot: BDOS seg
	pop	word [cs:part_off]		; pushed at init0 start from BPB hidden sectors
	pop	word [cs:part_off+2]
	jmp	init1			; next initialization stage is
					; part of discardable ICODE segment
init0	endp

copywords proc
	; copies up to 0ffffh words
	; ax = count
	; ds:0 = source segment
	; es:0 = destination segment
	; destroyed: si, di
	xor	si,si
	xor	di,di
 	test	ax,ax
 	js	@F		; more than 64K, take long route
	mov	cx,ax
	rep	movsw
	ret
@@:	mov	cx,8000h
	rep	movsw		; copy first 64K
	sub	ax,8000h	
	mov	cx,ax		; CX now contains how much left
	mov	ax,ds
	add	ax,1000h
	mov	ds,ax		; increase DS by 1000h (64K)
	mov	ax,es
	add	ax,1000h
	mov	es,ax		; increase ES by 1000h (64K)
	rep	movsw		; copy what is left
	ret

copywords endp

kernel_size	dw	0		; kernel file size in words
					; patched by compbios and compkern
COMPRESS_FROM_HERE:

%if ($ - init0) gt 512
	error "too much code in deblocking buffer"
%endif
		; grow deblocking buffer to 512 byte
		db	512 - ($ - init0) dup (?)
%else
local_buffer	db	512 dup (?)	; local deblocking buffer
%endif

SECSIZE		equ	512
IDOFF		equ	SECSIZE-2	; last word in boot sector is ID
PTOFF		equ	IDOFF-40h	; 4*16 bytes for partition def's
local_id equ local_buffer + IDOFF
local_pt equ local_buffer + PTOFF

	even
	Public	diskaddrpack
diskaddrpack:				; disk address packet structure for LBA access
		db	10h		; size of packet
		db	0		; reserved
		dw	1		; number of blocks to transfer
		dd	0		; transfer buffer address
		dq	0		; starting absolute block number

	public	bpbs,bpb160,bpb360,bpb720,NBPBS

;	List of BPBs that we usually support

bpb160:
istruc OLDBPB
at OLDBPB_SECSIZ
bpb160.OLDBPB_SECSIZ:	dw 512
at OLDBPB_ALLOCSIZ
bpb160.OLDBPB_ALLOCSIZ:	db 1
at OLDBPB_FATADD
bpb160.OLDBPB_FATADD:	dw 1
at OLDBPB_NFATS
bpb160.OLDBPB_NFATS:	db 2
at OLDBPB_DIRMAX
bpb160.OLDBPB_DIRMAX:	dw 64
at OLDBPB_TOTSEC
bpb160.OLDBPB_TOTSEC:	dw 40*1*8
at OLDBPB_FATID
bpb160.OLDBPB_FATID:	db 0FEh
at OLDBPB_FATSEC
bpb160.OLDBPB_FATSEC:	dw 1
at OLDBPB_SPT
bpb160.OLDBPB_SPT:	dw 8
at OLDBPB_HEADS
bpb160.OLDBPB_HEADS:	dw 1
at OLDBPB_HIDDEN
bpb160.OLDBPB_HIDDEN:	dd 0
at OLDBPB_SIZ
bpb160.OLDBPB_SIZ:	dd 0
at OLDBPB_RESRVD2
bpb160.OLDBPB_RESRVD2:
iend
bpb180:
istruc OLDBPB
at OLDBPB_SECSIZ
bpb180.OLDBPB_SECSIZ:	dw 512
at OLDBPB_ALLOCSIZ
bpb180.OLDBPB_ALLOCSIZ:	db 1
at OLDBPB_FATADD
bpb180.OLDBPB_FATADD:	dw 1
at OLDBPB_NFATS
bpb180.OLDBPB_NFATS:	db 2
at OLDBPB_DIRMAX
bpb180.OLDBPB_DIRMAX:	dw 64
at OLDBPB_TOTSEC
bpb180.OLDBPB_TOTSEC:	dw 40*1*9
at OLDBPB_FATID
bpb180.OLDBPB_FATID:	db 0FCh
at OLDBPB_FATSEC
bpb180.OLDBPB_FATSEC:	dw 2
at OLDBPB_SPT
bpb180.OLDBPB_SPT:	dw 9
at OLDBPB_HEADS
bpb180.OLDBPB_HEADS:	dw 1
at OLDBPB_HIDDEN
bpb180.OLDBPB_HIDDEN:	dd 0
at OLDBPB_SIZ
bpb180.OLDBPB_SIZ:	dd 0
at OLDBPB_RESRVD2
bpb180.OLDBPB_RESRVD2:
iend
bpb320:
istruc OLDBPB
at OLDBPB_SECSIZ
bpb320.OLDBPB_SECSIZ:	dw 512
at OLDBPB_ALLOCSIZ
bpb320.OLDBPB_ALLOCSIZ:	db 2
at OLDBPB_FATADD
bpb320.OLDBPB_FATADD:	dw 1
at OLDBPB_NFATS
bpb320.OLDBPB_NFATS:	db 2
at OLDBPB_DIRMAX
bpb320.OLDBPB_DIRMAX:	dw 112
at OLDBPB_TOTSEC
bpb320.OLDBPB_TOTSEC:	dw 40*2*8
at OLDBPB_FATID
bpb320.OLDBPB_FATID:	db 0FFh
at OLDBPB_FATSEC
bpb320.OLDBPB_FATSEC:	dw 1
at OLDBPB_SPT
bpb320.OLDBPB_SPT:	dw 8
at OLDBPB_HEADS
bpb320.OLDBPB_HEADS:	dw 2
at OLDBPB_HIDDEN
bpb320.OLDBPB_HIDDEN:	dd 0
at OLDBPB_SIZ
bpb320.OLDBPB_SIZ:	dd 0
at OLDBPB_RESRVD2
bpb320.OLDBPB_RESRVD2:
iend
bpb360:
istruc OLDBPB
at OLDBPB_SECSIZ
bpb360.OLDBPB_SECSIZ:	dw 512
at OLDBPB_ALLOCSIZ
bpb360.OLDBPB_ALLOCSIZ:	db 2
at OLDBPB_FATADD
bpb360.OLDBPB_FATADD:	dw 1
at OLDBPB_NFATS
bpb360.OLDBPB_NFATS:	db 2
at OLDBPB_DIRMAX
bpb360.OLDBPB_DIRMAX:	dw 112
at OLDBPB_TOTSEC
bpb360.OLDBPB_TOTSEC:	dw 40*2*9
at OLDBPB_FATID
bpb360.OLDBPB_FATID:	db 0FDh
at OLDBPB_FATSEC
bpb360.OLDBPB_FATSEC:	dw 2
at OLDBPB_SPT
bpb360.OLDBPB_SPT:	dw 9
at OLDBPB_HEADS
bpb360.OLDBPB_HEADS:	dw 2
at OLDBPB_HIDDEN
bpb360.OLDBPB_HIDDEN:	dd 0
at OLDBPB_SIZ
bpb360.OLDBPB_SIZ:	dd 0
at OLDBPB_RESRVD2
bpb360.OLDBPB_RESRVD2:
iend
bpb1200:
istruc OLDBPB
at OLDBPB_SECSIZ
bpb1200.OLDBPB_SECSIZ:	dw 512
at OLDBPB_ALLOCSIZ
bpb1200.OLDBPB_ALLOCSIZ:	db 1
at OLDBPB_FATADD
bpb1200.OLDBPB_FATADD:	dw 1
at OLDBPB_NFATS
bpb1200.OLDBPB_NFATS:	db 2
at OLDBPB_DIRMAX
bpb1200.OLDBPB_DIRMAX:	dw 224
at OLDBPB_TOTSEC
bpb1200.OLDBPB_TOTSEC:	dw 80*2*15
at OLDBPB_FATID
bpb1200.OLDBPB_FATID:	db 0F9h
at OLDBPB_FATSEC
bpb1200.OLDBPB_FATSEC:	dw 7
at OLDBPB_SPT
bpb1200.OLDBPB_SPT:	dw 15
at OLDBPB_HEADS
bpb1200.OLDBPB_HEADS:	dw 2
at OLDBPB_HIDDEN
bpb1200.OLDBPB_HIDDEN:	dd 0
at OLDBPB_SIZ
bpb1200.OLDBPB_SIZ:	dd 0
at OLDBPB_RESRVD2
bpb1200.OLDBPB_RESRVD2:
iend
bpb720:
istruc OLDBPB
at OLDBPB_SECSIZ
bpb720.OLDBPB_SECSIZ:	dw 512
at OLDBPB_ALLOCSIZ
bpb720.OLDBPB_ALLOCSIZ:	db 2
at OLDBPB_FATADD
bpb720.OLDBPB_FATADD:	dw 1
at OLDBPB_NFATS
bpb720.OLDBPB_NFATS:	db 2
at OLDBPB_DIRMAX
bpb720.OLDBPB_DIRMAX:	dw 112
at OLDBPB_TOTSEC
bpb720.OLDBPB_TOTSEC:	dw 80*2*9
at OLDBPB_FATID
bpb720.OLDBPB_FATID:	db 0F9h
at OLDBPB_FATSEC
bpb720.OLDBPB_FATSEC:	dw 3
at OLDBPB_SPT
bpb720.OLDBPB_SPT:	dw 9
at OLDBPB_HEADS
bpb720.OLDBPB_HEADS:	dw 2
at OLDBPB_HIDDEN
bpb720.OLDBPB_HIDDEN:	dd 0
at OLDBPB_SIZ
bpb720.OLDBPB_SIZ:	dd 0
at OLDBPB_RESRVD2
bpb720.OLDBPB_RESRVD2:
iend
bpb1440:
istruc OLDBPB
at OLDBPB_SECSIZ
bpb1440.OLDBPB_SECSIZ:	dw 512
at OLDBPB_ALLOCSIZ
bpb1440.OLDBPB_ALLOCSIZ:	db 1
at OLDBPB_FATADD
bpb1440.OLDBPB_FATADD:	dw 1
at OLDBPB_NFATS
bpb1440.OLDBPB_NFATS:	db 2
at OLDBPB_DIRMAX
bpb1440.OLDBPB_DIRMAX:	dw 224
at OLDBPB_TOTSEC
bpb1440.OLDBPB_TOTSEC:	dw 80*2*18
at OLDBPB_FATID
bpb1440.OLDBPB_FATID:	db 0F0h
at OLDBPB_FATSEC
bpb1440.OLDBPB_FATSEC:	dw 9
at OLDBPB_SPT
bpb1440.OLDBPB_SPT:	dw 18
at OLDBPB_HEADS
bpb1440.OLDBPB_HEADS:	dw 2
at OLDBPB_HIDDEN
bpb1440.OLDBPB_HIDDEN:	dd 0
at OLDBPB_SIZ
bpb1440.OLDBPB_SIZ:	dd 0
at OLDBPB_RESRVD2
bpb1440.OLDBPB_RESRVD2:
iend
bpb2880:
istruc OLDBPB
at OLDBPB_SECSIZ
bpb2880.OLDBPB_SECSIZ:	dw 512
at OLDBPB_ALLOCSIZ
bpb2880.OLDBPB_ALLOCSIZ:	db 2
at OLDBPB_FATADD
bpb2880.OLDBPB_FATADD:	dw 1
at OLDBPB_NFATS
bpb2880.OLDBPB_NFATS:	db 2
at OLDBPB_DIRMAX
bpb2880.OLDBPB_DIRMAX:	dw 240
at OLDBPB_TOTSEC
bpb2880.OLDBPB_TOTSEC:	dw 80*2*36
at OLDBPB_FATID
bpb2880.OLDBPB_FATID:	db 0F0h
at OLDBPB_FATSEC
bpb2880.OLDBPB_FATSEC:	dw 9
at OLDBPB_SPT
bpb2880.OLDBPB_SPT:	dw 36
at OLDBPB_HEADS
bpb2880.OLDBPB_HEADS:	dw 2
at OLDBPB_HIDDEN
bpb2880.OLDBPB_HIDDEN:	dd 0
at OLDBPB_SIZ
bpb2880.OLDBPB_SIZ:	dd 0
at OLDBPB_RESRVD2
bpb2880.OLDBPB_RESRVD2:
iend
NBPBS		equ	8

;	The following is a template, that gets overwritten
;	with the real parameters and is used while formatting

	public	local_parms,parms_spt,parms_gpl
	public	layout_table,bpbtbl

local_parms	db	11011111b	; step rate
		db	2		; DMA mode
		db	37		; 2*18.2 = 2 second motor off
		db	2		; 512 bytes per sector
parms_spt	db	18		; sectors per track
		db	2Ah		; gap length for read/write
		db	0FFh		; data length (128 byte/sector only)
parms_gpl	db	50h		; data length for format
		db	0F6h		; fill byte for format
		db	15		; head settle time in ms
		db	8		; motor on delay in 1/8s

; The BPB table need not survive config time, so share with layout table

bpbtbl		label	word

	MAX_SPT	equ	40
	
layout_table	label word		; current # of sectors/track

%assign variable_s 1

%rep	MAX_SPT
		;	C  H  S           N
		;	-  -  -           -
		db	0, 0, variable_s, 2
 %assign variable_s variable_s + 1
%endrep

	orgabs	600h, local_char	; CON: one character look-ahead buffer
; nb. it's at 61B in DOS 4.0

	Public	local_char, local_flag

local_char	db	0		;** fixed location **
local_flag	db	0		;** fixed location **

	even
	public	endbios
endbios		dw	offset RESBIOS_start wrt CGROUP	; pointer to last resident byte

CODE	ends

section ICODE public align=2 class=ICODE			; reusable initialization code

	Assume	CS:CGROUP, DS:CGROUP, ES:CGROUP, SS:Nothing

	align 2, db 0
bpbs		dw	offset bpb360	; 0: 320/360 Kb 5.25" floppy
		dw	offset bpb1200	; 1: 1.2 Mb 5.25" floppy
		dw	offset bpb720	; 2: 720 Kb 3.5" floppy
		dw	offset bpb360	; 3: (8" single density)
		dw	offset bpb360	; 4: (8" double density)
		dw	offset bpb360	; 5: hard disk
		dw	offset bpb360	; 6: tape drive
		dw	offset bpb1440	; 7: 1.44 Mb 3.5" floppy
		dw	offset bpb1440	; 8: Other
		dw	offset bpb2880	; 9: 2.88 Mb 3.5" floppy

%if SVARDOS
aux_prn_drvr_source:
.:
	dump_aux_prn_drvr
 %if $ - . != aux_prn_drvr_size
  %error Unexpected layout
 %endif
%endif

checkdebugger:	db 0

init1	proc	near

%if SVARDOS		; source is in compressed part, so copy it here
	push cx
	push di

		; Get lCFG items to use later.
	mov cl, byte [lcfg.checkdebugger]
	mov byte [cs:checkdebugger], cl
	push cs
	pop es
	mov di, aux_prn_drvr_destination
	push cs
	pop ds
	mov si, aux_prn_drvr_source
	mov cx, words(aux_prn_drvr_size)
	rep movsw

	pop di
	pop cx
%endif

%if SVARDOS eq 0
; 	DRBIO initialization code. This is executed right after the jump
; 	at the beginning of the CODE segment.

		; Get lCFG items to use later.
	mov es, cx
	mov cl, byte [es:di + LCFG_CheckDebugger]
	mov byte [cs:checkdebugger], cl

;
; We now uncompress to > (7C00h (ie. boot stack) - 700h (ie. base of code)
; This means our stack collides with our code, very bad news.
; To avoid this we switch stacks into a safer area ie. 0C000h
; The floppy parameters also MAY live at 7C00, so we have to relocate these
; before we expand.

	mov	byte [cs:A20Enable],0C3h
					; fixup the RET

	mov	sp, 0C000h		; switch to magic stack

	sti
	cld

	; the following expects ds:bp to point to the boot sector, in
	; particular the BPB, to push its hidden sectors field to stack
	push	word [ds:1eh + bp]		; push BPB hidden sectors
	push	word [ds:1ch + bp]		; ..popped at biosinit to part_off

	push	si			; drdoslen
	push	ax			; drdosseg
	push	cx			; save entry registers
	push	di			; (important in ROM systems)

%if COMPRESSED
	mov ds, ax
	mov cx, si
	mov ax, 1070h
	mov es, ax
	mov di, si
	std
	cmpsb
	rep movsb
	cld
	pop di
	pop cx
	pop si
	push ax
	push cx
	push di
%endif

	xor	si,si
	mov	ds,si
	mov	es,si

	Assume	DS:IVECT, ES:IVECT

; 	Copy diskette parameters (11 bytes) from the location stored
; 	at INT1E over to 0000:0522. This MAY previously be located at 7C00
; 	or another (non-)BIOS location depending on the boot sector code.
; 	After copying, set INT1E to point to the new location.

	mov	di,522h			; ES:DI -> save area for parameters
	lds	si,[i1Eptr]		; DS:SI -> FD parameters for ROS

	Assume	DS:Nothing

	mov	[es:i1Eoff],di
	mov	[es:i1Eseg],es		; setup new location
	mov	cx,11
	rep	movsb
	mov	byte ptr [es:di-7],36	; enable read/writing of 36 sectors/track

	pop	di
	pop	cx

%if COMPRESSED
	mov	si, cs			; preserve entry registers
	mov	ds, si			; other than si, ds and es
	mov	es, si
	xor	si, si
	mov	si, [compflg]		; Get Compresed BIOS Flag
	or	si, si			; Set to Zero if the BIOS has
	jnz	bios_r50_not_compressed		; been compressed
	mov	si, offset INITDATA_start wrt CGROUP
	push	di			; bios_seg
	push	ax			; bdos_seg
	push	bx			; initial drives
	push	cx			; memory size
	push	dx			; initial flags
	lea	cx, [biosinit_end]
	sub	cx, si
	inc	cx			; length of compressed part plus one
	mov	di, cx
	neg	di			; furthest offset we can use
	and	di, 0fff0h		; on the next para below
	push	di
	push	si
	shr	cx, 1
	rep movsw			; take a copy
	pop	di			; di is now -> compressed dest
	pop	si			; this is now -> compressed source
bios_r20:
	lodsw				; get control word
	mov	cx,ax			; as a count
	jcxz	bios_r40		; all done
	test	cx,8000h		; negative ?
	jnz	bios_r30		; yes do zeros
	rep	movsb			; else move in data bytes
	jmp short bios_r20		; and to the next

bios_r30:
	and	cx,7fffh		; remove sign
	jcxz	bios_r20		; none to do
	xor	ax,ax
	rep	stosb			; fill with zeros
	jmp short bios_r20
bios_r40:
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	di
bios_r50_not_compressed:
%endif	; compressed

%endif	; lDOS flavour init0

	mov	si,cs
	mov	ds,si			; DS -> local data segment
	cmp	dl,0ffh			; booting from ROM?
	 jz	rom_boot
	cmp	si,1000h		; test if debugging
	 jb	disk_boot		; skip if not

;	When the BIOS is loaded by the DOSLOAD or LOADER utilities under
;	Concurrent for DEBUGGING or in a ROM system then on entry AX
;	contains the current location of the BDOS and CX the memory Size.
;	Bx is the current code segment

	mov	[cs:rcode_seg],dx		; rom segment of bios
	mov	[cs:current_dos],ax		; current location of the BDOS
	mov	[cs:mem_size],cx		; total memory size
	mov	[cs:init_drv],bl		; initial drive
	mov	[cs:comspec_drv],bh		;
	mov	byte [cs:init_buf],3		; assume default # of buffers
	mov	word [cs:init_flags],3	
	jmp	bios_exit
	
rom_boot:				; BIOS is copied from ROM:
					; 	DL = 0FFh
					;	AX = segment address of DRBDOS
					;	BH = COMSPEC drive
					;	BL = INIT_DRV
	mov	[cs:rcode_seg],di		;	DI = BIOS ROM SEG
	mov	[cs:current_dos],ax		; current location of the BDOS
	mov	[cs:init_drv],bl		; initial drive C:
	mov	[cs:comspec_drv],bh		; commspec drive C:
	mov	word [cs:init_flags],3		; it is a ROM system, use comspec drive
	jmps	rom_boot10		; common code

disk_boot:
	mov	[cs:rcode_seg],cs
	sub	ax,ax
	mov	[cs:current_dos],ax		; current BDOS location to disk load
	xchg	ax,dx			; AL = boot drive
	mov	[cs:init_runit],al		; save the ROS unit
	mov	[cs:init_int13_unit],al	; save the ROS unit
	cmp	al,80h			; test the boot drive
	 jb	floppy_boot		; skip if floppy boot
	mov	al,2			; it's a hard drive
floppy_boot:
	mov	[cs:init_drv],al		; set boot drive

rom_boot10:
	pushx	<ds, es>		; save registers
	sub	bx,bx
	mov	ds,bx			; DS:BX -> interrupt vectors

	Assume	DS:IVECT

	push	cs			; we want to save vectors some
	pop	es			;  locally

	lea	di,[vecSave]
	mov	cx,NUM_SAVED_VECS	; restore this many vectors
SaveVectors:
	xor	ax,ax			; zero AH
	mov	al,[es:di]		; AX = vector to save
	inc	di			; skip to save position
	shl	ax,1
	shl	ax,1			; point at address
	xchg	ax,si			; DS:SI -> location to save
	movsw
	movsw				; save this vector
	loop	SaveVectors		; go and do another

debugger_check:
%if SVARDOS && 0
	test	byte [es:kernflg],DEBUG_FLG
	jz	debugger_disabled
	clc
%else
	mov al, byte [cs:checkdebugger]
	test al, LCFG_DBG_ONLY_VALID
	jz @F
		; ds => IVT
	cmp word [i3off], -1
	je .nocheck
	cmp word [i3seg], 0
	je .nocheck
@@:
	test al, LCFG_DBG_ONLY_IISP
	jz @F
		; ds => IVT
	les bx, [i3off]			; es:bx -> int 3 handler
	cmp bx, -18			; valid ? (could tear word access ?)
	ja .nocheck			; no, cannot be a valid IISP header -->
	cmp word [es:bx + 6], "KB"	; signature present ?
	jne .nocheck			; no -->
@@:
	test al, LCFG_DBG_CHECK
	jnz .check
.nocheck:
	mov byte [cs:.patch], 90h	; do not check
	jmp @F				; (flush queue for the SMC)
@@:
.check:
	test al, LCFG_DBG_ASSUME	; (NC)
	jz .runint3			; if to assume off --> (NC)
	stc				; assume on (CY)
.runint3:
%endif
.patch:	int3				; SMC: patched to NOP if not to run int3
	jc debugger_detected
debugger_disabled:
	mov	word [i0off],offset Int0Trap
	mov	[i0seg],cs		; now grab int0 vector
	mov	word [i1off],offset Int1Trap
	mov	[i1seg],cs		; now grab int1 vector
	mov	word [i3off],offset Int1Trap
	mov	[i3seg],cs		; now grab int3 vector

debugger_detected:
	mov	word [i4off],offset Int1Trap
	mov	[i4seg],cs		; now grab int4 vector
	mov	word [i19off],offset Int19Trap
	mov	[i19seg],cs		; now grab int19 vector

	popx	<es, ds>

	Assume	DS:CGROUP, ES:CGROUP

%if SVARDOS
	mov	si,offset kernel_ver_msg
	call	output_msg
	mov	si,offset repository_msg
	call	output_msg
%else
	mov	si,offset drdosprojects_msg
	call	output_msg
	mov	si,offset starting_dos_msg
	call	output_msg
%endif

	mov	ah,EXT_MEMORY
	int	SYSTEM_INT		; find out how much extended memory
	 jnc	bios_extmem
	xor	ax,ax			; say we have no memory
bios_extmem:
	mov	[ext_mem_size],ax		;  we have and store for reference
	
	mov	byte [init_buf],3		; assume default of 3 buffers
	int	MEMORY_INT		; get amount of conventional memory
	cmp	ax,128
	 jbe	bios_mem
	mov	byte [init_buf],5		; use 5 buffers if > 128K of memory
bios_mem:				; get amount of conventional memory
	mov	cl,6			;    in kilobytes (AX)
	shl	ax,cl			; convert Kb's to paragraphs
	mov	[mem_size],ax		; set end of TPA

bios_exit:
; The following code performs the fixups necessary for ROM executable
; internal device drivers.
	mov	ax,cs			; check if we are on a rommed system
	cmp	ax,[rcode_seg]
	 jne	keep_rcode		; if so no relocation required
	mov	ax,offset RCODE_start wrt CGROUP
	mov	[rcode_offset],ax		; fixup variable need
	mov	bx,offset IDATA_start wrt CGROUP
	sub	bx,ax
	mov	[icode_len],bx		; during init we need RCODE and ICODE
	mov	bx,offset RESUMECODE_start wrt CGROUP
	sub	bx,ax
	mov	[rcode_header],bx
	mov	[rcode_len],bx		; afterwards we just need RCODE
keep_rcode:

; If the system ROM BIOS supports RESUME mode then it will call Int 6C
; when returning from sleep mode. We take this over and reset the clock
; based upon the RTC value. To save space we only relocate the code if
; required.
;
	mov	ax,4100h		; does the BIOS support resume mode
	xor	bx,bx
	int	15h			; lets ask it
	 jc	resume_exit
	push	ds
	xor	ax,ax
	mov	ds,ax			; DS = vectors
Assume DS:IVECT
	mov	word [i6Coff],offset Resume
	mov	[i6Cseg],cs		; point Int 6C at resume code
Assume DS:CGROUP
	pop	ds
	mov	ax,cs			; check if we are on a rommed system
	cmp	ax,[rcode_seg]
	 jne	resume_exit		; if so nothing extra to keep
	mov	ax,offset RESBIOS_start wrt CGROUP
	sub	ax,offset RCODE_start wrt CGROUP
	mov	[rcode_header],ax		; keep Resume code as well...
	mov	[rcode_len],ax		; afterwards we just need RCODE
resume_exit:
	mov	ax,offset ENDCODE_start wrt CGROUP	; discard RCODE (we will relocate it)
	mov	[endbios],ax
	mov	word [rcode_fixups],offset bios_fixup_tbl

	mov	bx,offset con_drvr		; get first device driver in chain
	mov	word ptr [device_root+0],bx
	mov	word ptr [device_root+2],ds

@@next_fixup:
	cmp	word ptr [bx],0FFFFh	; last driver in BIOS?
	 je	@@fixup_done
	mov	[2 + bx],ds		; fix up segments in driver chain
	mov	bx,[bx]
	jmp	short @@next_fixup
@@fixup_done:
	jmp	biosinit		; jump to BIOS code

init1	endp

	public	output_msg
output_msg:
;----------------
; On Entry:
;	si = offset message_msg
; On Exit:
;	None
	pushx	<ax,bx>
	lodsb				; get 1st character (never NULL)
output_msg10:
	mov	ah,0Eh
	mov	bx,7
	int	VIDEO_INT		; TTY write of character	
	lodsb				; fetch another character
	test	al,al			; end of string ?
	 jnz	output_msg10
	popx	<bx,ax>
	ret

	public	output_hex
output_hex:
;----------------
; On Entry:
;	dx = 2 byte hex value
; On Exit:
;	None
; Used Regs:
;	ax,bx,cx,dx,si
	pushx	<ax,bx,cx,si>
	mov	cx,4
	mov	ah,0eh
	mov	bx,7
output_hex10:
	mov	al,dh
	push	cx
	mov	cl,4
	shr	al,cl
	pop	cx
	and	al,0fh
	cmp	al,09h			; greater 0-9?
	jg	output_hex20
	add	al,30h
	jmp	output_hex30
output_hex20:
	add	al,37h
output_hex30:
	int	VIDEO_INT
	push	cx
	mov	cl,4
	shl	dx,cl
	pop	cx
	loop	output_hex10
	mov	si,offset output_hex40
	call	output_msg
	popx	<si,cx,bx,ax>
	ret
output_hex40	db	20h,NUL		; end of string

ICODE	ends

section INITDATA public align=16 class=INITDATA

%if SVARDOS
	extrn	part_off:word
%endif

; This is a zero terminated list of locations to be fixed up with the
; segment of the relocated BIOS RCODE

bios_fixup_tbl	dw	offset MemFixup
		dw	offset OutputBSFixup
		dw	offset DriverFunctionFixup
		dw	offset Int0Fixup
		dw	offset Int13DeblockFixup
		dw	offset Int13UnsureFixup
		dw	offset Int2FFixup
		dw	offset ResumeFixup
%IFDEF EMBEDDED
		dw	offset RdiskFixup
%endif
		dw	0

%if SVARDOS
%include "svarver.mac"

kernel_ver_msg	db KERNEL_VER_STR, 0
repository_msg	db REPOSITORY_STR, 0
%else

%ifndef LDOS
 %assign LDOS 0
%elifempty LDOS
 %assign LDOS 1
%endif

%if LDOS
	drdosprojects_msg	db	CR, LF
db "lDOS Enhanced DR-DOS kernel fork               https://hg.pushbx.org/ecm/edrdos"
				db CR, LF, NUL
;lDOS Enhanced DR-DOS kernel fork               https://hg.pushbx.org/ecm/edrdos
;Enhanced DR-DOS continuation                  https://github.com/svardos/edrdos
;The DR-DOS/OpenDOS Enhancement Project              http://www.drdosprojects.de
;12345678901234567890123456789012345678901234567890123456789012345678901234567890
%elif SVARDOS
	drdosprojects_msg	db	CR, LF, "Enhanced DR-DOS continuation                  https://github.com/svardos/edrdos", CR, LF, NUL
%else
	drdosprojects_msg	db	CR, LF, "The DR-DOS/OpenDOS Enhancement Project              http://www.drdosprojects.de", CR, LF, NUL
%endif
starting_dos_msg	db	CR, LF, "Starting "
%define SHORTVERSION 1
shortversion equ 1
			%include "version.mac"
			db	CR, LF, NUL
%endif

INITDATA	ends

section CODE class=CODE
%IFDEF EMBEDDED
	extrn	RdiskFixup:word
%endif
CODE	ends


section RCODE_ALIGN public align=16 class=RCODE
%ifndef ROMSYS
;	db	1100h dup(0)		; reserve space for command.com
	db	1A00h dup(0)		; reserve space for command.com
%endif
RCODE_ALIGN	ends

section RCODE public align=2 class=RCODE

rcode_header	dw	0

	Public	DataSegment

DataSegment	dw	BIO_SEG		; segment address of low data/code

; Called to vector to appropriate sub-function in device driver
; The Function table address immediately follows the near call, so we can index
; into it using the return address. If the offset is in the range 0-6 it's
; actually a device number for the serial/parallel driver
;
;
; On Entry to subfunctions ES:BX -> req_hdr, DX = devno (serial/parallel)
;

FunctionTable	struc
Max	db	?
Entry	dw	?
FunctionTable	ends

	Public	DriverFunction

DriverFunction	proc	far
	cld
	sub	sp,(P_STRUC_size)-4	; make space for stack variables
	push	bp			; (BP and RET are included)
	mov	bp,sp			; set up stack frame
	pushx	<ds,es>
	pushx	<ax,bx,cx,dx,si,di>	; save all registers
	mov	ds,[cs:DataSegment]
	mov	si,[bp+(P_STRUC_size)-2]	; get return address = command table
	lodsw				; AX = following word
	xchg	ax,dx			; DX = device number (0-6)
	mov	si,offset SerParCommonTable
	cmp	dx,6			; if not a device number it's a table
	 jbe	DriverFunction10
	mov	si,dx			; DS:SI -> table
DriverFunction10:
	les	bx,[req_ptr]		; ES:BX -> request header
P_STRUC.REQUEST_OFF equ REQUEST_OFF	; NASM port label
	mov	[P_STRUC.REQUEST_OFF + bp],bx
P_STRUC.REQUEST_SEG equ REQUEST_SEG	; NASM port label
	mov	[P_STRUC.REQUEST_SEG + bp],es
	mov	al,[es:RH_CMD + bx]	; check if legal command
FunctionTable.Max equ Max	; NASM port label
	cmp	al,[cs:FunctionTable.Max + si]
	 ja	cmderr			; skip if out of range
	cbw				; convert to word
	add	ax,ax			;  make it a word offset
	add	si,ax			; add index to function table
FunctionTable.Entry equ Entry	; NASM port label
	call	[cs:FunctionTable.Entry + si]
P_DSTRUC.REQUEST equ REQUEST	; NASM port label
	les	bx,[P_DSTRUC.REQUEST + bp]
cmddone:
	or	ax,RHS_DONE		; indicate request is "done"
	mov	[es:RH_STATUS + bx],ax	; update the status for BDOS
	popx	<di,si,dx,cx,bx,ax>	; restore all registers
	popx	<es,ds>
	pop	bp
	add	sp,(P_STRUC_size)-2	; discard stack variables 
	ret

cmderr:
	mov	ax,RHS_ERROR+3		; "invalid command" error
	jmps	cmddone			; return the error

DriverFunction	endp



OutputBS proc far
;-------
;	pushx	<ax, bx, si, di, bp>	; these are on the stack
	pushx	<cx, dx>
	mov	ah,3			; get cursor address
	xor	bh,bh			; on page zero
	int	VIDEO_INT		; BH = page, DH/DL = cursor row/col
	test	dx,dx			; row 0, col 0
	 jz	OutputBS10		; ignore if first line
	dec	dl			; are we in column 0?
	 jns	OutputBS10		; no, normal BS
	dec	dh			; else move up one line
	push	ds
	xor	ax,ax
	mov	ds,ax
	mov	dl,byte ptr [44ah]	; DL = # of columns
	dec	dx			; DL = last column
	pop	ds
	mov	ah,2			; set cursor, DH/DL = cursor, BH = page
	int	VIDEO_INT		; set cursor address
	jmps	OutputBS20

OutputBS10:
	mov	ax,0E08h		; use ROS TTY-like output function
	mov	bx,7			; use the normal attribute
	int	VIDEO_INT		; output the character in AL
OutputBS20:
	popx	<dx, cx>
	popx	<bp, di, si, bx, ax>
	iret

OutputBS endp


	extern div_by_zero_length

i0_disp_ax_hex:
	xchg al, ah
	call i0_disp_al_hex
	xchg al, ah

i0_disp_al_hex:
	mov cl, 4
	ror al, cl
	call i0_disp_al_nybble_hex
	ror al, cl
i0_disp_al_nybble_hex:
	push ax
	and al, 15
	add al, '0'
	cmp al, '9'
	jbe .dec
	add al, 'A' - ('9' + 1)
.dec:
	call i0_disp_al
	pop ax
	retn

i0_disp_ax:
	call i0_disp_al
	xchg al, ah

		; INP:	bx = STDERR
		;	al = text byte
		; CHG:	dx
i0_disp_al:
	push cx
	push ds
	push ax
	 push ss
	 pop ds
	mov cx, 1
	mov dx, sp
	mov ah, MS_X_WRITE
	int DOS_INT
	pop ax
	pop ds
	pop cx
	retn


Int0Handler proc far
;----------
	cld
	mov bp, sp
	push ax
	push bx
	push cx
	push dx
	push	cs
	pop	ds
	mov	dx,offset div_by_zero_msg	; DS:SI points at ASCIZ message
	mov	bx,STDERR		; to STDERR - where else ?
	mov	cx, div_by_zero_length		; write one at a time
	mov	ah,MS_X_WRITE		; write out the error
	int	DOS_INT

	mov ax, [bp + 2]
	call i0_disp_ax_hex
	mov al, ':'
	call i0_disp_al

	mov ax, [bp]
	call i0_disp_ax_hex
	mov ax, "->"
	call i0_disp_ax

	lds si, [bp]
	mov di, 16
.loop:
	mov al, ' '
	call i0_disp_al
	lodsb
	call i0_disp_al_hex
	dec di
	jnz .loop

	mov ax, 13 | (10 << 8)
	call i0_disp_ax

	mov si, i0_table
.loop_table:
	mov al, ' '
	call i0_disp_al
	cs lodsw
	call i0_disp_ax
	mov al, '='
	call i0_disp_al
	cs lodsb
	cbw
	xchg di, ax
	mov ax, [bp + di]
	call i0_disp_ax_hex
	cmp si, i0_table.end
	jb .loop_table

	mov ax, 13 | (10 << 8)
	call i0_disp_ax

	mov	ax,MS_X_EXIT*256+1	; time to leave - say we got an error
	int	DOS_INT			; go for it!

Int0Handler endp

i0_table:
	db "AX", -2
	db "BX", -4
	db "CX", -6
	db "DX", -8
.end:

RCODE		ends

	end	init
