#! /bin/bash

# Public Domain

nasm -P nasm.mac -f obj -l head.lst -o head.obj head.nas
nasm -P nasm.mac -f obj -l pcntpk.lst -o pcntpk.obj -DENGLISH pcntpk.nas
nasm -P nasm.mac -f obj -l tail.lst -o tail.obj tail.nas
nasm -P nasm.mac -f obj -l pninit.lst -o pninit.obj pninit.nas

[ -z "$DOSEMU" ] && DOSEMU=dosemu
"$DOSEMU" -dumb -td -kt -q -quiet -K "$PWD" -E "lnk.bat"

for file in *.lst
do
  mkdir -p listing
  iconv -f CP858 -t UTF-8 "$file" -o listing/"$file"
done

convlist.pl pcntpk.map listing/head.lst listing/pcntpk.lst \
  listing/tail.lst listing/pninit.lst > pcntpk.tls
